package zio.aws.comprehend.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.comprehend.model.primitives.{
  MaxResultsInteger,
  ComprehendFlywheelArn
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListFlywheelIterationHistoryRequest(
    flywheelArn: ComprehendFlywheelArn,
    filter: Optional[zio.aws.comprehend.model.FlywheelIterationFilter] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[MaxResultsInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ListFlywheelIterationHistoryRequest = {
    import ListFlywheelIterationHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ListFlywheelIterationHistoryRequest
      .builder()
      .flywheelArn(ComprehendFlywheelArn.unwrap(flywheelArn): java.lang.String)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResultsInteger.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.ListFlywheelIterationHistoryRequest.ReadOnly =
    zio.aws.comprehend.model.ListFlywheelIterationHistoryRequest
      .wrap(buildAwsValue())
}
object ListFlywheelIterationHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ListFlywheelIterationHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.ListFlywheelIterationHistoryRequest =
      zio.aws.comprehend.model.ListFlywheelIterationHistoryRequest(
        flywheelArn,
        filter.map(value => value.asEditable),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def flywheelArn: ComprehendFlywheelArn
    def filter
        : Optional[zio.aws.comprehend.model.FlywheelIterationFilter.ReadOnly]
    def nextToken: Optional[String]
    def maxResults: Optional[MaxResultsInteger]
    def getFlywheelArn: ZIO[Any, Nothing, ComprehendFlywheelArn] =
      ZIO.succeed(flywheelArn)
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.FlywheelIterationFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ListFlywheelIterationHistoryRequest
  ) extends zio.aws.comprehend.model.ListFlywheelIterationHistoryRequest.ReadOnly {
    override val flywheelArn: ComprehendFlywheelArn =
      zio.aws.comprehend.model.primitives
        .ComprehendFlywheelArn(impl.flywheelArn())
    override val filter
        : Optional[zio.aws.comprehend.model.FlywheelIterationFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value =>
          zio.aws.comprehend.model.FlywheelIterationFilter.wrap(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[MaxResultsInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.comprehend.model.primitives.MaxResultsInteger(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ListFlywheelIterationHistoryRequest
  ): zio.aws.comprehend.model.ListFlywheelIterationHistoryRequest.ReadOnly =
    new Wrapper(impl)
}
