package zio.aws.comprehend.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.comprehend.model.primitives.{Timestamp, ComprehendModelArn}
import scala.jdk.CollectionConverters.*
final case class EndpointFilter(
    modelArn: Optional[ComprehendModelArn] = Optional.Absent,
    status: Optional[zio.aws.comprehend.model.EndpointStatus] = Optional.Absent,
    creationTimeBefore: Optional[Timestamp] = Optional.Absent,
    creationTimeAfter: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.EndpointFilter = {
    import EndpointFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.EndpointFilter
      .builder()
      .optionallyWith(
        modelArn.map(value =>
          ComprehendModelArn.unwrap(value): java.lang.String
        )
      )(_.modelArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(
        creationTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.EndpointFilter.ReadOnly =
    zio.aws.comprehend.model.EndpointFilter.wrap(buildAwsValue())
}
object EndpointFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.EndpointFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.EndpointFilter =
      zio.aws.comprehend.model.EndpointFilter(
        modelArn.map(value => value),
        status.map(value => value),
        creationTimeBefore.map(value => value),
        creationTimeAfter.map(value => value)
      )
    def modelArn: Optional[ComprehendModelArn]
    def status: Optional[zio.aws.comprehend.model.EndpointStatus]
    def creationTimeBefore: Optional[Timestamp]
    def creationTimeAfter: Optional[Timestamp]
    def getModelArn: ZIO[Any, AwsError, ComprehendModelArn] =
      AwsError.unwrapOptionField("modelArn", modelArn)
    def getStatus: ZIO[Any, AwsError, zio.aws.comprehend.model.EndpointStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getCreationTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.EndpointFilter
  ) extends zio.aws.comprehend.model.EndpointFilter.ReadOnly {
    override val modelArn: Optional[ComprehendModelArn] = zio.aws.core.internal
      .optionalFromNullable(impl.modelArn())
      .map(value =>
        zio.aws.comprehend.model.primitives.ComprehendModelArn(value)
      )
    override val status: Optional[zio.aws.comprehend.model.EndpointStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.comprehend.model.EndpointStatus.wrap(value))
    override val creationTimeBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeBefore())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val creationTimeAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeAfter())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.EndpointFilter
  ): zio.aws.comprehend.model.EndpointFilter.ReadOnly = new Wrapper(impl)
}
