package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.CustomerInputString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchDetectSyntaxRequest(
    textList: Iterable[CustomerInputString],
    languageCode: zio.aws.comprehend.model.SyntaxLanguageCode
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.BatchDetectSyntaxRequest = {
    import BatchDetectSyntaxRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.BatchDetectSyntaxRequest
      .builder()
      .textList(textList.map { item =>
        CustomerInputString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .languageCode(languageCode.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.BatchDetectSyntaxRequest.ReadOnly =
    zio.aws.comprehend.model.BatchDetectSyntaxRequest.wrap(buildAwsValue())
}
object BatchDetectSyntaxRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.BatchDetectSyntaxRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.BatchDetectSyntaxRequest =
      zio.aws.comprehend.model.BatchDetectSyntaxRequest(textList, languageCode)
    def textList: List[CustomerInputString]
    def languageCode: zio.aws.comprehend.model.SyntaxLanguageCode
    def getTextList: ZIO[Any, Nothing, List[CustomerInputString]] =
      ZIO.succeed(textList)
    def getLanguageCode
        : ZIO[Any, Nothing, zio.aws.comprehend.model.SyntaxLanguageCode] =
      ZIO.succeed(languageCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.BatchDetectSyntaxRequest
  ) extends zio.aws.comprehend.model.BatchDetectSyntaxRequest.ReadOnly {
    override val textList: List[CustomerInputString] = impl
      .textList()
      .asScala
      .map { item =>
        zio.aws.comprehend.model.primitives.CustomerInputString(item)
      }
      .toList
    override val languageCode: zio.aws.comprehend.model.SyntaxLanguageCode =
      zio.aws.comprehend.model.SyntaxLanguageCode.wrap(impl.languageCode())
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.BatchDetectSyntaxRequest
  ): zio.aws.comprehend.model.BatchDetectSyntaxRequest.ReadOnly = new Wrapper(
    impl
  )
}
