package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DetectSyntaxResponse(
    syntaxTokens: Optional[Iterable[zio.aws.comprehend.model.SyntaxToken]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DetectSyntaxResponse = {
    import DetectSyntaxResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DetectSyntaxResponse
      .builder()
      .optionallyWith(
        syntaxTokens.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.syntaxTokens)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.DetectSyntaxResponse.ReadOnly =
    zio.aws.comprehend.model.DetectSyntaxResponse.wrap(buildAwsValue())
}
object DetectSyntaxResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DetectSyntaxResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DetectSyntaxResponse =
      zio.aws.comprehend.model.DetectSyntaxResponse(
        syntaxTokens.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def syntaxTokens
        : Optional[List[zio.aws.comprehend.model.SyntaxToken.ReadOnly]]
    def getSyntaxTokens: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.SyntaxToken.ReadOnly
    ]] = AwsError.unwrapOptionField("syntaxTokens", syntaxTokens)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DetectSyntaxResponse
  ) extends zio.aws.comprehend.model.DetectSyntaxResponse.ReadOnly {
    override val syntaxTokens
        : Optional[List[zio.aws.comprehend.model.SyntaxToken.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.syntaxTokens())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.comprehend.model.SyntaxToken.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DetectSyntaxResponse
  ): zio.aws.comprehend.model.DetectSyntaxResponse.ReadOnly = new Wrapper(impl)
}
