package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListEntitiesDetectionJobsResponse(
    entitiesDetectionJobPropertiesList: Optional[
      Iterable[zio.aws.comprehend.model.EntitiesDetectionJobProperties]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsResponse = {
    import ListEntitiesDetectionJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsResponse
      .builder()
      .optionallyWith(
        entitiesDetectionJobPropertiesList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.entitiesDetectionJobPropertiesList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.ListEntitiesDetectionJobsResponse.ReadOnly =
    zio.aws.comprehend.model.ListEntitiesDetectionJobsResponse
      .wrap(buildAwsValue())
}
object ListEntitiesDetectionJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.ListEntitiesDetectionJobsResponse =
      zio.aws.comprehend.model.ListEntitiesDetectionJobsResponse(
        entitiesDetectionJobPropertiesList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def entitiesDetectionJobPropertiesList: Optional[
      List[zio.aws.comprehend.model.EntitiesDetectionJobProperties.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getEntitiesDetectionJobPropertiesList: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.EntitiesDetectionJobProperties.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "entitiesDetectionJobPropertiesList",
      entitiesDetectionJobPropertiesList
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsResponse
  ) extends zio.aws.comprehend.model.ListEntitiesDetectionJobsResponse.ReadOnly {
    override val entitiesDetectionJobPropertiesList: Optional[
      List[zio.aws.comprehend.model.EntitiesDetectionJobProperties.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.entitiesDetectionJobPropertiesList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.comprehend.model.EntitiesDetectionJobProperties.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsResponse
  ): zio.aws.comprehend.model.ListEntitiesDetectionJobsResponse.ReadOnly =
    new Wrapper(impl)
}
