package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.CustomerInputString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DetectSyntaxRequest(
    text: CustomerInputString,
    languageCode: zio.aws.comprehend.model.SyntaxLanguageCode
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DetectSyntaxRequest = {
    import DetectSyntaxRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DetectSyntaxRequest
      .builder()
      .text(CustomerInputString.unwrap(text): java.lang.String)
      .languageCode(languageCode.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.DetectSyntaxRequest.ReadOnly =
    zio.aws.comprehend.model.DetectSyntaxRequest.wrap(buildAwsValue())
}
object DetectSyntaxRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DetectSyntaxRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DetectSyntaxRequest =
      zio.aws.comprehend.model.DetectSyntaxRequest(text, languageCode)
    def text: CustomerInputString
    def languageCode: zio.aws.comprehend.model.SyntaxLanguageCode
    def getText: ZIO[Any, Nothing, CustomerInputString] = ZIO.succeed(text)
    def getLanguageCode
        : ZIO[Any, Nothing, zio.aws.comprehend.model.SyntaxLanguageCode] =
      ZIO.succeed(languageCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DetectSyntaxRequest
  ) extends zio.aws.comprehend.model.DetectSyntaxRequest.ReadOnly {
    override val text: CustomerInputString =
      zio.aws.comprehend.model.primitives.CustomerInputString(impl.text())
    override val languageCode: zio.aws.comprehend.model.SyntaxLanguageCode =
      zio.aws.comprehend.model.SyntaxLanguageCode.wrap(impl.languageCode())
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DetectSyntaxRequest
  ): zio.aws.comprehend.model.DetectSyntaxRequest.ReadOnly = new Wrapper(impl)
}
