package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DetectDominantLanguageResponse(
    languages: Optional[Iterable[zio.aws.comprehend.model.DominantLanguage]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DetectDominantLanguageResponse = {
    import DetectDominantLanguageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DetectDominantLanguageResponse
      .builder()
      .optionallyWith(
        languages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.languages)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DetectDominantLanguageResponse.ReadOnly =
    zio.aws.comprehend.model.DetectDominantLanguageResponse
      .wrap(buildAwsValue())
}
object DetectDominantLanguageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DetectDominantLanguageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DetectDominantLanguageResponse =
      zio.aws.comprehend.model.DetectDominantLanguageResponse(
        languages.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def languages
        : Optional[List[zio.aws.comprehend.model.DominantLanguage.ReadOnly]]
    def getLanguages: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.DominantLanguage.ReadOnly
    ]] = AwsError.unwrapOptionField("languages", languages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DetectDominantLanguageResponse
  ) extends zio.aws.comprehend.model.DetectDominantLanguageResponse.ReadOnly {
    override val languages
        : Optional[List[zio.aws.comprehend.model.DominantLanguage.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.languages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.comprehend.model.DominantLanguage.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DetectDominantLanguageResponse
  ): zio.aws.comprehend.model.DetectDominantLanguageResponse.ReadOnly =
    new Wrapper(impl)
}
