package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchDetectTargetedSentimentResponse(
    resultList: Iterable[
      zio.aws.comprehend.model.BatchDetectTargetedSentimentItemResult
    ],
    errorList: Iterable[zio.aws.comprehend.model.BatchItemError]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.BatchDetectTargetedSentimentResponse = {
    import BatchDetectTargetedSentimentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.BatchDetectTargetedSentimentResponse
      .builder()
      .resultList(resultList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .errorList(errorList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.BatchDetectTargetedSentimentResponse.ReadOnly =
    zio.aws.comprehend.model.BatchDetectTargetedSentimentResponse
      .wrap(buildAwsValue())
}
object BatchDetectTargetedSentimentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.BatchDetectTargetedSentimentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.BatchDetectTargetedSentimentResponse =
      zio.aws.comprehend.model.BatchDetectTargetedSentimentResponse(
        resultList.map { item =>
          item.asEditable
        },
        errorList.map { item =>
          item.asEditable
        }
      )
    def resultList: List[
      zio.aws.comprehend.model.BatchDetectTargetedSentimentItemResult.ReadOnly
    ]
    def errorList: List[zio.aws.comprehend.model.BatchItemError.ReadOnly]
    def getResultList: ZIO[Any, Nothing, List[
      zio.aws.comprehend.model.BatchDetectTargetedSentimentItemResult.ReadOnly
    ]] = ZIO.succeed(resultList)
    def getErrorList: ZIO[Any, Nothing, List[
      zio.aws.comprehend.model.BatchItemError.ReadOnly
    ]] = ZIO.succeed(errorList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.BatchDetectTargetedSentimentResponse
  ) extends zio.aws.comprehend.model.BatchDetectTargetedSentimentResponse.ReadOnly {
    override val resultList: List[
      zio.aws.comprehend.model.BatchDetectTargetedSentimentItemResult.ReadOnly
    ] = impl
      .resultList()
      .asScala
      .map { item =>
        zio.aws.comprehend.model.BatchDetectTargetedSentimentItemResult
          .wrap(item)
      }
      .toList
    override val errorList
        : List[zio.aws.comprehend.model.BatchItemError.ReadOnly] = impl
      .errorList()
      .asScala
      .map { item =>
        zio.aws.comprehend.model.BatchItemError.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.BatchDetectTargetedSentimentResponse
  ): zio.aws.comprehend.model.BatchDetectTargetedSentimentResponse.ReadOnly =
    new Wrapper(impl)
}
