package zio.aws.comprehend.model
import scala.jdk.CollectionConverters.*
sealed trait DocumentReadFeatureTypes {
  def unwrap: software.amazon.awssdk.services.comprehend.model.DocumentReadFeatureTypes
}
object DocumentReadFeatureTypes {
  def wrap(
      value: software.amazon.awssdk.services.comprehend.model.DocumentReadFeatureTypes
  ): zio.aws.comprehend.model.DocumentReadFeatureTypes = value match {
    case software.amazon.awssdk.services.comprehend.model.DocumentReadFeatureTypes.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.comprehend.model.DocumentReadFeatureTypes.TABLES =>
      val r = TABLES
      r
    case software.amazon.awssdk.services.comprehend.model.DocumentReadFeatureTypes.FORMS =>
      val r = FORMS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.comprehend.model.DocumentReadFeatureTypes {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.DocumentReadFeatureTypes =
      software.amazon.awssdk.services.comprehend.model.DocumentReadFeatureTypes.UNKNOWN_TO_SDK_VERSION
  }
  case object TABLES extends zio.aws.comprehend.model.DocumentReadFeatureTypes {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.DocumentReadFeatureTypes =
      software.amazon.awssdk.services.comprehend.model.DocumentReadFeatureTypes.TABLES
  }
  case object FORMS extends zio.aws.comprehend.model.DocumentReadFeatureTypes {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.DocumentReadFeatureTypes =
      software.amazon.awssdk.services.comprehend.model.DocumentReadFeatureTypes.FORMS
  }
}
