package zio.aws.comprehend.model
import scala.jdk.CollectionConverters.*
sealed trait PartOfSpeechTagType {
  def unwrap
      : software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType
}
object PartOfSpeechTagType {
  def wrap(
      value: software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType
  ): zio.aws.comprehend.model.PartOfSpeechTagType = value match {
    case software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType.ADJ =>
      val r = ADJ
      r
    case software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType.ADP =>
      val r = ADP
      r
    case software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType.ADV =>
      val r = ADV
      r
    case software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType.AUX =>
      val r = AUX
      r
    case software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType.CONJ =>
      val r = CONJ
      r
    case software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType.CCONJ =>
      val r = CCONJ
      r
    case software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType.DET =>
      val r = DET
      r
    case software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType.INTJ =>
      val r = INTJ
      r
    case software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType.NOUN =>
      val r = NOUN
      r
    case software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType.NUM =>
      val r = NUM
      r
    case software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType.O =>
      val r = O
      r
    case software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType.PART =>
      val r = PART
      r
    case software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType.PRON =>
      val r = PRON
      r
    case software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType.PROPN =>
      val r = PROPN
      r
    case software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType.PUNCT =>
      val r = PUNCT
      r
    case software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType.SCONJ =>
      val r = SCONJ
      r
    case software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType.SYM =>
      val r = SYM
      r
    case software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType.VERB =>
      val r = VERB
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.comprehend.model.PartOfSpeechTagType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType =
      software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType.UNKNOWN_TO_SDK_VERSION
  }
  case object ADJ extends zio.aws.comprehend.model.PartOfSpeechTagType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType =
      software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType.ADJ
  }
  case object ADP extends zio.aws.comprehend.model.PartOfSpeechTagType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType =
      software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType.ADP
  }
  case object ADV extends zio.aws.comprehend.model.PartOfSpeechTagType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType =
      software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType.ADV
  }
  case object AUX extends zio.aws.comprehend.model.PartOfSpeechTagType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType =
      software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType.AUX
  }
  case object CONJ extends zio.aws.comprehend.model.PartOfSpeechTagType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType =
      software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType.CONJ
  }
  case object CCONJ extends zio.aws.comprehend.model.PartOfSpeechTagType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType =
      software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType.CCONJ
  }
  case object DET extends zio.aws.comprehend.model.PartOfSpeechTagType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType =
      software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType.DET
  }
  case object INTJ extends zio.aws.comprehend.model.PartOfSpeechTagType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType =
      software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType.INTJ
  }
  case object NOUN extends zio.aws.comprehend.model.PartOfSpeechTagType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType =
      software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType.NOUN
  }
  case object NUM extends zio.aws.comprehend.model.PartOfSpeechTagType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType =
      software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType.NUM
  }
  case object O extends zio.aws.comprehend.model.PartOfSpeechTagType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType =
      software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType.O
  }
  case object PART extends zio.aws.comprehend.model.PartOfSpeechTagType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType =
      software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType.PART
  }
  case object PRON extends zio.aws.comprehend.model.PartOfSpeechTagType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType =
      software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType.PRON
  }
  case object PROPN extends zio.aws.comprehend.model.PartOfSpeechTagType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType =
      software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType.PROPN
  }
  case object PUNCT extends zio.aws.comprehend.model.PartOfSpeechTagType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType =
      software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType.PUNCT
  }
  case object SCONJ extends zio.aws.comprehend.model.PartOfSpeechTagType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType =
      software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType.SCONJ
  }
  case object SYM extends zio.aws.comprehend.model.PartOfSpeechTagType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType =
      software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType.SYM
  }
  case object VERB extends zio.aws.comprehend.model.PartOfSpeechTagType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType =
      software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType.VERB
  }
}
