package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.JobId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StopPiiEntitiesDetectionJobRequest(jobId: JobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.StopPiiEntitiesDetectionJobRequest = {
    import StopPiiEntitiesDetectionJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.StopPiiEntitiesDetectionJobRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.StopPiiEntitiesDetectionJobRequest.ReadOnly =
    zio.aws.comprehend.model.StopPiiEntitiesDetectionJobRequest
      .wrap(buildAwsValue())
}
object StopPiiEntitiesDetectionJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.StopPiiEntitiesDetectionJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.StopPiiEntitiesDetectionJobRequest =
      zio.aws.comprehend.model.StopPiiEntitiesDetectionJobRequest(jobId)
    def jobId: JobId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.StopPiiEntitiesDetectionJobRequest
  ) extends zio.aws.comprehend.model.StopPiiEntitiesDetectionJobRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.comprehend.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.StopPiiEntitiesDetectionJobRequest
  ): zio.aws.comprehend.model.StopPiiEntitiesDetectionJobRequest.ReadOnly =
    new Wrapper(impl)
}
