package zio.aws.comprehend.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.comprehend.model.primitives.{
  IamRoleArn,
  ComprehendModelArn,
  AnyLengthString,
  Timestamp,
  ComprehendEndpointArn,
  InferenceUnitsInteger
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class EndpointProperties(
    endpointArn: Optional[ComprehendEndpointArn] = Optional.Absent,
    status: Optional[zio.aws.comprehend.model.EndpointStatus] = Optional.Absent,
    message: Optional[AnyLengthString] = Optional.Absent,
    modelArn: Optional[ComprehendModelArn] = Optional.Absent,
    desiredModelArn: Optional[ComprehendModelArn] = Optional.Absent,
    desiredInferenceUnits: Optional[InferenceUnitsInteger] = Optional.Absent,
    currentInferenceUnits: Optional[InferenceUnitsInteger] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    dataAccessRoleArn: Optional[IamRoleArn] = Optional.Absent,
    desiredDataAccessRoleArn: Optional[IamRoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.EndpointProperties = {
    import EndpointProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.EndpointProperties
      .builder()
      .optionallyWith(
        endpointArn.map(value =>
          ComprehendEndpointArn.unwrap(value): java.lang.String
        )
      )(_.endpointArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        message.map(value => AnyLengthString.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        modelArn.map(value =>
          ComprehendModelArn.unwrap(value): java.lang.String
        )
      )(_.modelArn)
      .optionallyWith(
        desiredModelArn.map(value =>
          ComprehendModelArn.unwrap(value): java.lang.String
        )
      )(_.desiredModelArn)
      .optionallyWith(
        desiredInferenceUnits.map(value =>
          InferenceUnitsInteger.unwrap(value): Integer
        )
      )(_.desiredInferenceUnits)
      .optionallyWith(
        currentInferenceUnits.map(value =>
          InferenceUnitsInteger.unwrap(value): Integer
        )
      )(_.currentInferenceUnits)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        dataAccessRoleArn.map(value =>
          IamRoleArn.unwrap(value): java.lang.String
        )
      )(_.dataAccessRoleArn)
      .optionallyWith(
        desiredDataAccessRoleArn.map(value =>
          IamRoleArn.unwrap(value): java.lang.String
        )
      )(_.desiredDataAccessRoleArn)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.EndpointProperties.ReadOnly =
    zio.aws.comprehend.model.EndpointProperties.wrap(buildAwsValue())
}
object EndpointProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.EndpointProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.EndpointProperties =
      zio.aws.comprehend.model.EndpointProperties(
        endpointArn.map(value => value),
        status.map(value => value),
        message.map(value => value),
        modelArn.map(value => value),
        desiredModelArn.map(value => value),
        desiredInferenceUnits.map(value => value),
        currentInferenceUnits.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value),
        dataAccessRoleArn.map(value => value),
        desiredDataAccessRoleArn.map(value => value)
      )
    def endpointArn: Optional[ComprehendEndpointArn]
    def status: Optional[zio.aws.comprehend.model.EndpointStatus]
    def message: Optional[AnyLengthString]
    def modelArn: Optional[ComprehendModelArn]
    def desiredModelArn: Optional[ComprehendModelArn]
    def desiredInferenceUnits: Optional[InferenceUnitsInteger]
    def currentInferenceUnits: Optional[InferenceUnitsInteger]
    def creationTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def dataAccessRoleArn: Optional[IamRoleArn]
    def desiredDataAccessRoleArn: Optional[IamRoleArn]
    def getEndpointArn: ZIO[Any, AwsError, ComprehendEndpointArn] =
      AwsError.unwrapOptionField("endpointArn", endpointArn)
    def getStatus: ZIO[Any, AwsError, zio.aws.comprehend.model.EndpointStatus] =
      AwsError.unwrapOptionField("status", status)
    def getMessage: ZIO[Any, AwsError, AnyLengthString] =
      AwsError.unwrapOptionField("message", message)
    def getModelArn: ZIO[Any, AwsError, ComprehendModelArn] =
      AwsError.unwrapOptionField("modelArn", modelArn)
    def getDesiredModelArn: ZIO[Any, AwsError, ComprehendModelArn] =
      AwsError.unwrapOptionField("desiredModelArn", desiredModelArn)
    def getDesiredInferenceUnits: ZIO[Any, AwsError, InferenceUnitsInteger] =
      AwsError.unwrapOptionField("desiredInferenceUnits", desiredInferenceUnits)
    def getCurrentInferenceUnits: ZIO[Any, AwsError, InferenceUnitsInteger] =
      AwsError.unwrapOptionField("currentInferenceUnits", currentInferenceUnits)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getDataAccessRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("dataAccessRoleArn", dataAccessRoleArn)
    def getDesiredDataAccessRoleArn: ZIO[Any, AwsError, IamRoleArn] = AwsError
      .unwrapOptionField("desiredDataAccessRoleArn", desiredDataAccessRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.EndpointProperties
  ) extends zio.aws.comprehend.model.EndpointProperties.ReadOnly {
    override val endpointArn: Optional[ComprehendEndpointArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointArn())
        .map(value =>
          zio.aws.comprehend.model.primitives.ComprehendEndpointArn(value)
        )
    override val status: Optional[zio.aws.comprehend.model.EndpointStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.comprehend.model.EndpointStatus.wrap(value))
    override val message: Optional[AnyLengthString] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.comprehend.model.primitives.AnyLengthString(value))
    override val modelArn: Optional[ComprehendModelArn] = zio.aws.core.internal
      .optionalFromNullable(impl.modelArn())
      .map(value =>
        zio.aws.comprehend.model.primitives.ComprehendModelArn(value)
      )
    override val desiredModelArn: Optional[ComprehendModelArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.desiredModelArn())
        .map(value =>
          zio.aws.comprehend.model.primitives.ComprehendModelArn(value)
        )
    override val desiredInferenceUnits: Optional[InferenceUnitsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.desiredInferenceUnits())
        .map(value =>
          zio.aws.comprehend.model.primitives.InferenceUnitsInteger(value)
        )
    override val currentInferenceUnits: Optional[InferenceUnitsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentInferenceUnits())
        .map(value =>
          zio.aws.comprehend.model.primitives.InferenceUnitsInteger(value)
        )
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val dataAccessRoleArn: Optional[IamRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.dataAccessRoleArn())
      .map(value => zio.aws.comprehend.model.primitives.IamRoleArn(value))
    override val desiredDataAccessRoleArn: Optional[IamRoleArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.desiredDataAccessRoleArn())
        .map(value => zio.aws.comprehend.model.primitives.IamRoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.EndpointProperties
  ): zio.aws.comprehend.model.EndpointProperties.ReadOnly = new Wrapper(impl)
}
