package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.JobId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeTopicsDetectionJobRequest(jobId: JobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DescribeTopicsDetectionJobRequest = {
    import DescribeTopicsDetectionJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DescribeTopicsDetectionJobRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DescribeTopicsDetectionJobRequest.ReadOnly =
    zio.aws.comprehend.model.DescribeTopicsDetectionJobRequest
      .wrap(buildAwsValue())
}
object DescribeTopicsDetectionJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DescribeTopicsDetectionJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DescribeTopicsDetectionJobRequest =
      zio.aws.comprehend.model.DescribeTopicsDetectionJobRequest(jobId)
    def jobId: JobId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeTopicsDetectionJobRequest
  ) extends zio.aws.comprehend.model.DescribeTopicsDetectionJobRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.comprehend.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeTopicsDetectionJobRequest
  ): zio.aws.comprehend.model.DescribeTopicsDetectionJobRequest.ReadOnly =
    new Wrapper(impl)
}
