package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ChildBlock(
    childBlockId: Optional[String] = Optional.Absent,
    beginOffset: Optional[Integer] = Optional.Absent,
    endOffset: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ChildBlock = {
    import ChildBlock.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ChildBlock
      .builder()
      .optionallyWith(childBlockId.map(value => value: java.lang.String))(
        _.childBlockId
      )
      .optionallyWith(beginOffset.map(value => value: java.lang.Integer))(
        _.beginOffset
      )
      .optionallyWith(endOffset.map(value => value: java.lang.Integer))(
        _.endOffset
      )
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.ChildBlock.ReadOnly =
    zio.aws.comprehend.model.ChildBlock.wrap(buildAwsValue())
}
object ChildBlock {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ChildBlock
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.ChildBlock =
      zio.aws.comprehend.model.ChildBlock(
        childBlockId.map(value => value),
        beginOffset.map(value => value),
        endOffset.map(value => value)
      )
    def childBlockId: Optional[String]
    def beginOffset: Optional[Integer]
    def endOffset: Optional[Integer]
    def getChildBlockId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("childBlockId", childBlockId)
    def getBeginOffset: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("beginOffset", beginOffset)
    def getEndOffset: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("endOffset", endOffset)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ChildBlock
  ) extends zio.aws.comprehend.model.ChildBlock.ReadOnly {
    override val childBlockId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.childBlockId())
      .map(value => value: String)
    override val beginOffset: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.beginOffset())
      .map(value => value: Integer)
    override val endOffset: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.endOffset())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ChildBlock
  ): zio.aws.comprehend.model.ChildBlock.ReadOnly = new Wrapper(impl)
}
