package zio.aws.comprehend.model
import scala.jdk.CollectionConverters.*
sealed trait BlockType {
  def unwrap: software.amazon.awssdk.services.comprehend.model.BlockType
}
object BlockType {
  def wrap(
      value: software.amazon.awssdk.services.comprehend.model.BlockType
  ): zio.aws.comprehend.model.BlockType = value match {
    case software.amazon.awssdk.services.comprehend.model.BlockType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.comprehend.model.BlockType.LINE =>
      val r = LINE
      r
    case software.amazon.awssdk.services.comprehend.model.BlockType.WORD =>
      val r = WORD
      r
  }
  case object unknownToSdkVersion extends zio.aws.comprehend.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.BlockType =
      software.amazon.awssdk.services.comprehend.model.BlockType.UNKNOWN_TO_SDK_VERSION
  }
  case object LINE extends zio.aws.comprehend.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.BlockType =
      software.amazon.awssdk.services.comprehend.model.BlockType.LINE
  }
  case object WORD extends zio.aws.comprehend.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.BlockType =
      software.amazon.awssdk.services.comprehend.model.BlockType.WORD
  }
}
