package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{
  ComprehendArnName,
  IamRoleArn,
  ComprehendModelArn,
  KmsKeyId,
  VersionName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ImportModelRequest(
    sourceModelArn: ComprehendModelArn,
    modelName: Optional[ComprehendArnName] = Optional.Absent,
    versionName: Optional[VersionName] = Optional.Absent,
    modelKmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    dataAccessRoleArn: Optional[IamRoleArn] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.comprehend.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ImportModelRequest = {
    import ImportModelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ImportModelRequest
      .builder()
      .sourceModelArn(
        ComprehendModelArn.unwrap(sourceModelArn): java.lang.String
      )
      .optionallyWith(
        modelName.map(value =>
          ComprehendArnName.unwrap(value): java.lang.String
        )
      )(_.modelName)
      .optionallyWith(
        versionName.map(value => VersionName.unwrap(value): java.lang.String)
      )(_.versionName)
      .optionallyWith(
        modelKmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.modelKmsKeyId)
      .optionallyWith(
        dataAccessRoleArn.map(value =>
          IamRoleArn.unwrap(value): java.lang.String
        )
      )(_.dataAccessRoleArn)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.ImportModelRequest.ReadOnly =
    zio.aws.comprehend.model.ImportModelRequest.wrap(buildAwsValue())
}
object ImportModelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ImportModelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.ImportModelRequest =
      zio.aws.comprehend.model.ImportModelRequest(
        sourceModelArn,
        modelName.map(value => value),
        versionName.map(value => value),
        modelKmsKeyId.map(value => value),
        dataAccessRoleArn.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def sourceModelArn: ComprehendModelArn
    def modelName: Optional[ComprehendArnName]
    def versionName: Optional[VersionName]
    def modelKmsKeyId: Optional[KmsKeyId]
    def dataAccessRoleArn: Optional[IamRoleArn]
    def tags: Optional[List[zio.aws.comprehend.model.Tag.ReadOnly]]
    def getSourceModelArn: ZIO[Any, Nothing, ComprehendModelArn] =
      ZIO.succeed(sourceModelArn)
    def getModelName: ZIO[Any, AwsError, ComprehendArnName] =
      AwsError.unwrapOptionField("modelName", modelName)
    def getVersionName: ZIO[Any, AwsError, VersionName] =
      AwsError.unwrapOptionField("versionName", versionName)
    def getModelKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("modelKmsKeyId", modelKmsKeyId)
    def getDataAccessRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("dataAccessRoleArn", dataAccessRoleArn)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.comprehend.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ImportModelRequest
  ) extends zio.aws.comprehend.model.ImportModelRequest.ReadOnly {
    override val sourceModelArn: ComprehendModelArn =
      zio.aws.comprehend.model.primitives
        .ComprehendModelArn(impl.sourceModelArn())
    override val modelName: Optional[ComprehendArnName] = zio.aws.core.internal
      .optionalFromNullable(impl.modelName())
      .map(value =>
        zio.aws.comprehend.model.primitives.ComprehendArnName(value)
      )
    override val versionName: Optional[VersionName] = zio.aws.core.internal
      .optionalFromNullable(impl.versionName())
      .map(value => zio.aws.comprehend.model.primitives.VersionName(value))
    override val modelKmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.modelKmsKeyId())
      .map(value => zio.aws.comprehend.model.primitives.KmsKeyId(value))
    override val dataAccessRoleArn: Optional[IamRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.dataAccessRoleArn())
      .map(value => zio.aws.comprehend.model.primitives.IamRoleArn(value))
    override val tags: Optional[List[zio.aws.comprehend.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.comprehend.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ImportModelRequest
  ): zio.aws.comprehend.model.ImportModelRequest.ReadOnly = new Wrapper(impl)
}
