package zio.aws.comprehend.model
import scala.jdk.CollectionConverters.*
sealed trait DocumentClassifierDataFormat {
  def unwrap: software.amazon.awssdk.services.comprehend.model.DocumentClassifierDataFormat
}
object DocumentClassifierDataFormat {
  def wrap(
      value: software.amazon.awssdk.services.comprehend.model.DocumentClassifierDataFormat
  ): zio.aws.comprehend.model.DocumentClassifierDataFormat = value match {
    case software.amazon.awssdk.services.comprehend.model.DocumentClassifierDataFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.comprehend.model.DocumentClassifierDataFormat.COMPREHEND_CSV =>
      val r = COMPREHEND_CSV
      r
    case software.amazon.awssdk.services.comprehend.model.DocumentClassifierDataFormat.AUGMENTED_MANIFEST =>
      val r = AUGMENTED_MANIFEST
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.comprehend.model.DocumentClassifierDataFormat {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.DocumentClassifierDataFormat =
      software.amazon.awssdk.services.comprehend.model.DocumentClassifierDataFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object COMPREHEND_CSV
      extends zio.aws.comprehend.model.DocumentClassifierDataFormat {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.DocumentClassifierDataFormat =
      software.amazon.awssdk.services.comprehend.model.DocumentClassifierDataFormat.COMPREHEND_CSV
  }
  case object AUGMENTED_MANIFEST
      extends zio.aws.comprehend.model.DocumentClassifierDataFormat {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.DocumentClassifierDataFormat =
      software.amazon.awssdk.services.comprehend.model.DocumentClassifierDataFormat.AUGMENTED_MANIFEST
  }
}
