package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{SubnetId, SecurityGroupId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class VpcConfig(
    securityGroupIds: Iterable[SecurityGroupId],
    subnets: Iterable[SubnetId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.VpcConfig = {
    import VpcConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.VpcConfig
      .builder()
      .securityGroupIds(securityGroupIds.map { item =>
        SecurityGroupId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .subnets(subnets.map { item =>
        SubnetId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.VpcConfig.ReadOnly =
    zio.aws.comprehend.model.VpcConfig.wrap(buildAwsValue())
}
object VpcConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.VpcConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.VpcConfig =
      zio.aws.comprehend.model.VpcConfig(securityGroupIds, subnets)
    def securityGroupIds: List[SecurityGroupId]
    def subnets: List[SubnetId]
    def getSecurityGroupIds: ZIO[Any, Nothing, List[SecurityGroupId]] =
      ZIO.succeed(securityGroupIds)
    def getSubnets: ZIO[Any, Nothing, List[SubnetId]] = ZIO.succeed(subnets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.VpcConfig
  ) extends zio.aws.comprehend.model.VpcConfig.ReadOnly {
    override val securityGroupIds: List[SecurityGroupId] = impl
      .securityGroupIds()
      .asScala
      .map { item =>
        zio.aws.comprehend.model.primitives.SecurityGroupId(item)
      }
      .toList
    override val subnets: List[SubnetId] = impl
      .subnets()
      .asScala
      .map { item =>
        zio.aws.comprehend.model.primitives.SubnetId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.VpcConfig
  ): zio.aws.comprehend.model.VpcConfig.ReadOnly = new Wrapper(impl)
}
