package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.JobId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StopSentimentDetectionJobRequest(jobId: JobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.StopSentimentDetectionJobRequest = {
    import StopSentimentDetectionJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.StopSentimentDetectionJobRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.StopSentimentDetectionJobRequest.ReadOnly =
    zio.aws.comprehend.model.StopSentimentDetectionJobRequest
      .wrap(buildAwsValue())
}
object StopSentimentDetectionJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.StopSentimentDetectionJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.StopSentimentDetectionJobRequest =
      zio.aws.comprehend.model.StopSentimentDetectionJobRequest(jobId)
    def jobId: JobId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.StopSentimentDetectionJobRequest
  ) extends zio.aws.comprehend.model.StopSentimentDetectionJobRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.comprehend.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.StopSentimentDetectionJobRequest
  ): zio.aws.comprehend.model.StopSentimentDetectionJobRequest.ReadOnly =
    new Wrapper(impl)
}
