package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DocumentLabel(
    name: Optional[String] = Optional.Absent,
    score: Optional[Float] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DocumentLabel = {
    import DocumentLabel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DocumentLabel
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(score.map(value => value: java.lang.Float))(_.score)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.DocumentLabel.ReadOnly =
    zio.aws.comprehend.model.DocumentLabel.wrap(buildAwsValue())
}
object DocumentLabel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DocumentLabel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DocumentLabel =
      zio.aws.comprehend.model
        .DocumentLabel(name.map(value => value), score.map(value => value))
    def name: Optional[String]
    def score: Optional[Float]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getScore: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("score", score)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DocumentLabel
  ) extends zio.aws.comprehend.model.DocumentLabel.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val score: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.score())
      .map(value => value: Float)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DocumentLabel
  ): zio.aws.comprehend.model.DocumentLabel.ReadOnly = new Wrapper(impl)
}
