package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.DocumentClassifierArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeDocumentClassifierRequest(
    documentClassifierArn: DocumentClassifierArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassifierRequest = {
    import DescribeDocumentClassifierRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassifierRequest
      .builder()
      .documentClassifierArn(
        DocumentClassifierArn.unwrap(documentClassifierArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DescribeDocumentClassifierRequest.ReadOnly =
    zio.aws.comprehend.model.DescribeDocumentClassifierRequest
      .wrap(buildAwsValue())
}
object DescribeDocumentClassifierRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassifierRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DescribeDocumentClassifierRequest =
      zio.aws.comprehend.model
        .DescribeDocumentClassifierRequest(documentClassifierArn)
    def documentClassifierArn: DocumentClassifierArn
    def getDocumentClassifierArn: ZIO[Any, Nothing, DocumentClassifierArn] =
      ZIO.succeed(documentClassifierArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassifierRequest
  ) extends zio.aws.comprehend.model.DescribeDocumentClassifierRequest.ReadOnly {
    override val documentClassifierArn: DocumentClassifierArn =
      zio.aws.comprehend.model.primitives
        .DocumentClassifierArn(impl.documentClassifierArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassifierRequest
  ): zio.aws.comprehend.model.DescribeDocumentClassifierRequest.ReadOnly =
    new Wrapper(impl)
}
