package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{
  DocumentClassifierEndpointArn,
  CustomerInputString
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ClassifyDocumentRequest(
    text: CustomerInputString,
    endpointArn: DocumentClassifierEndpointArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ClassifyDocumentRequest = {
    import ClassifyDocumentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ClassifyDocumentRequest
      .builder()
      .text(CustomerInputString.unwrap(text): java.lang.String)
      .endpointArn(
        DocumentClassifierEndpointArn.unwrap(endpointArn): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.ClassifyDocumentRequest.ReadOnly =
    zio.aws.comprehend.model.ClassifyDocumentRequest.wrap(buildAwsValue())
}
object ClassifyDocumentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ClassifyDocumentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.ClassifyDocumentRequest =
      zio.aws.comprehend.model.ClassifyDocumentRequest(text, endpointArn)
    def text: CustomerInputString
    def endpointArn: DocumentClassifierEndpointArn
    def getText: ZIO[Any, Nothing, CustomerInputString] = ZIO.succeed(text)
    def getEndpointArn: ZIO[Any, Nothing, DocumentClassifierEndpointArn] =
      ZIO.succeed(endpointArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ClassifyDocumentRequest
  ) extends zio.aws.comprehend.model.ClassifyDocumentRequest.ReadOnly {
    override val text: CustomerInputString =
      zio.aws.comprehend.model.primitives.CustomerInputString(impl.text())
    override val endpointArn: DocumentClassifierEndpointArn =
      zio.aws.comprehend.model.primitives
        .DocumentClassifierEndpointArn(impl.endpointArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ClassifyDocumentRequest
  ): zio.aws.comprehend.model.ClassifyDocumentRequest.ReadOnly = new Wrapper(
    impl
  )
}
