package zio.aws.comprehend.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.comprehend.model.primitives.MaxResultsInteger
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListEntityRecognizersRequest(
    filter: Optional[zio.aws.comprehend.model.EntityRecognizerFilter] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[MaxResultsInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest = {
    import ListEntityRecognizersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest
      .builder()
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResultsInteger.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.ListEntityRecognizersRequest.ReadOnly =
    zio.aws.comprehend.model.ListEntityRecognizersRequest.wrap(buildAwsValue())
}
object ListEntityRecognizersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.ListEntityRecognizersRequest =
      zio.aws.comprehend.model.ListEntityRecognizersRequest(
        filter.map(value => value.asEditable),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def filter
        : Optional[zio.aws.comprehend.model.EntityRecognizerFilter.ReadOnly]
    def nextToken: Optional[String]
    def maxResults: Optional[MaxResultsInteger]
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.EntityRecognizerFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest
  ) extends zio.aws.comprehend.model.ListEntityRecognizersRequest.ReadOnly {
    override val filter
        : Optional[zio.aws.comprehend.model.EntityRecognizerFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value =>
          zio.aws.comprehend.model.EntityRecognizerFilter.wrap(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[MaxResultsInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.comprehend.model.primitives.MaxResultsInteger(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest
  ): zio.aws.comprehend.model.ListEntityRecognizersRequest.ReadOnly =
    new Wrapper(impl)
}
