package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListDocumentClassifiersResponse(
    documentClassifierPropertiesList: Optional[
      Iterable[zio.aws.comprehend.model.DocumentClassifierProperties]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersResponse = {
    import ListDocumentClassifiersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersResponse
      .builder()
      .optionallyWith(
        documentClassifierPropertiesList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.documentClassifierPropertiesList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.ListDocumentClassifiersResponse.ReadOnly =
    zio.aws.comprehend.model.ListDocumentClassifiersResponse
      .wrap(buildAwsValue())
}
object ListDocumentClassifiersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.ListDocumentClassifiersResponse =
      zio.aws.comprehend.model.ListDocumentClassifiersResponse(
        documentClassifierPropertiesList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def documentClassifierPropertiesList: Optional[
      List[zio.aws.comprehend.model.DocumentClassifierProperties.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getDocumentClassifierPropertiesList: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.DocumentClassifierProperties.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "documentClassifierPropertiesList",
      documentClassifierPropertiesList
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersResponse
  ) extends zio.aws.comprehend.model.ListDocumentClassifiersResponse.ReadOnly {
    override val documentClassifierPropertiesList: Optional[
      List[zio.aws.comprehend.model.DocumentClassifierProperties.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.documentClassifierPropertiesList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.comprehend.model.DocumentClassifierProperties.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersResponse
  ): zio.aws.comprehend.model.ListDocumentClassifiersResponse.ReadOnly =
    new Wrapper(impl)
}
