package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListEntityRecognizerSummariesResponse(
    entityRecognizerSummariesList: Optional[
      Iterable[zio.aws.comprehend.model.EntityRecognizerSummary]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesResponse = {
    import ListEntityRecognizerSummariesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesResponse
      .builder()
      .optionallyWith(
        entityRecognizerSummariesList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.entityRecognizerSummariesList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.ListEntityRecognizerSummariesResponse.ReadOnly =
    zio.aws.comprehend.model.ListEntityRecognizerSummariesResponse
      .wrap(buildAwsValue())
}
object ListEntityRecognizerSummariesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.ListEntityRecognizerSummariesResponse =
      zio.aws.comprehend.model.ListEntityRecognizerSummariesResponse(
        entityRecognizerSummariesList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def entityRecognizerSummariesList: Optional[
      List[zio.aws.comprehend.model.EntityRecognizerSummary.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getEntityRecognizerSummariesList: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.EntityRecognizerSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "entityRecognizerSummariesList",
      entityRecognizerSummariesList
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesResponse
  ) extends zio.aws.comprehend.model.ListEntityRecognizerSummariesResponse.ReadOnly {
    override val entityRecognizerSummariesList: Optional[
      List[zio.aws.comprehend.model.EntityRecognizerSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.entityRecognizerSummariesList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.comprehend.model.EntityRecognizerSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesResponse
  ): zio.aws.comprehend.model.ListEntityRecognizerSummariesResponse.ReadOnly =
    new Wrapper(impl)
}
