package zio.aws.comprehend.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.comprehend.model.primitives.{Timestamp, JobName}
import scala.jdk.CollectionConverters.*
final case class DominantLanguageDetectionJobFilter(
    jobName: Optional[JobName] = Optional.Absent,
    jobStatus: Optional[zio.aws.comprehend.model.JobStatus] = Optional.Absent,
    submitTimeBefore: Optional[Timestamp] = Optional.Absent,
    submitTimeAfter: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DominantLanguageDetectionJobFilter = {
    import DominantLanguageDetectionJobFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DominantLanguageDetectionJobFilter
      .builder()
      .optionallyWith(
        jobName.map(value => JobName.unwrap(value): java.lang.String)
      )(_.jobName)
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(
        submitTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.submitTimeBefore)
      .optionallyWith(
        submitTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.submitTimeAfter)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DominantLanguageDetectionJobFilter.ReadOnly =
    zio.aws.comprehend.model.DominantLanguageDetectionJobFilter
      .wrap(buildAwsValue())
}
object DominantLanguageDetectionJobFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DominantLanguageDetectionJobFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.DominantLanguageDetectionJobFilter =
      zio.aws.comprehend.model.DominantLanguageDetectionJobFilter(
        jobName.map(value => value),
        jobStatus.map(value => value),
        submitTimeBefore.map(value => value),
        submitTimeAfter.map(value => value)
      )
    def jobName: Optional[JobName]
    def jobStatus: Optional[zio.aws.comprehend.model.JobStatus]
    def submitTimeBefore: Optional[Timestamp]
    def submitTimeAfter: Optional[Timestamp]
    def getJobName: ZIO[Any, AwsError, JobName] =
      AwsError.unwrapOptionField("jobName", jobName)
    def getJobStatus: ZIO[Any, AwsError, zio.aws.comprehend.model.JobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getSubmitTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("submitTimeBefore", submitTimeBefore)
    def getSubmitTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("submitTimeAfter", submitTimeAfter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DominantLanguageDetectionJobFilter
  ) extends zio.aws.comprehend.model.DominantLanguageDetectionJobFilter.ReadOnly {
    override val jobName: Optional[JobName] = zio.aws.core.internal
      .optionalFromNullable(impl.jobName())
      .map(value => zio.aws.comprehend.model.primitives.JobName(value))
    override val jobStatus: Optional[zio.aws.comprehend.model.JobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobStatus())
        .map(value => zio.aws.comprehend.model.JobStatus.wrap(value))
    override val submitTimeBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.submitTimeBefore())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val submitTimeAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.submitTimeAfter())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DominantLanguageDetectionJobFilter
  ): zio.aws.comprehend.model.DominantLanguageDetectionJobFilter.ReadOnly =
    new Wrapper(impl)
}
