package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.ComprehendEndpointArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeEndpointRequest(endpointArn: ComprehendEndpointArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DescribeEndpointRequest = {
    import DescribeEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DescribeEndpointRequest
      .builder()
      .endpointArn(ComprehendEndpointArn.unwrap(endpointArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.DescribeEndpointRequest.ReadOnly =
    zio.aws.comprehend.model.DescribeEndpointRequest.wrap(buildAwsValue())
}
object DescribeEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DescribeEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DescribeEndpointRequest =
      zio.aws.comprehend.model.DescribeEndpointRequest(endpointArn)
    def endpointArn: ComprehendEndpointArn
    def getEndpointArn: ZIO[Any, Nothing, ComprehendEndpointArn] =
      ZIO.succeed(endpointArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeEndpointRequest
  ) extends zio.aws.comprehend.model.DescribeEndpointRequest.ReadOnly {
    override val endpointArn: ComprehendEndpointArn =
      zio.aws.comprehend.model.primitives
        .ComprehendEndpointArn(impl.endpointArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeEndpointRequest
  ): zio.aws.comprehend.model.DescribeEndpointRequest.ReadOnly = new Wrapper(
    impl
  )
}
