package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SentimentScore(
    positive: Optional[Float] = Optional.Absent,
    negative: Optional[Float] = Optional.Absent,
    neutral: Optional[Float] = Optional.Absent,
    mixed: Optional[Float] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.SentimentScore = {
    import SentimentScore.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.SentimentScore
      .builder()
      .optionallyWith(positive.map(value => value: java.lang.Float))(_.positive)
      .optionallyWith(negative.map(value => value: java.lang.Float))(_.negative)
      .optionallyWith(neutral.map(value => value: java.lang.Float))(_.neutral)
      .optionallyWith(mixed.map(value => value: java.lang.Float))(_.mixed)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.SentimentScore.ReadOnly =
    zio.aws.comprehend.model.SentimentScore.wrap(buildAwsValue())
}
object SentimentScore {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.SentimentScore
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.SentimentScore =
      zio.aws.comprehend.model.SentimentScore(
        positive.map(value => value),
        negative.map(value => value),
        neutral.map(value => value),
        mixed.map(value => value)
      )
    def positive: Optional[Float]
    def negative: Optional[Float]
    def neutral: Optional[Float]
    def mixed: Optional[Float]
    def getPositive: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("positive", positive)
    def getNegative: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("negative", negative)
    def getNeutral: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("neutral", neutral)
    def getMixed: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("mixed", mixed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.SentimentScore
  ) extends zio.aws.comprehend.model.SentimentScore.ReadOnly {
    override val positive: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.positive())
      .map(value => value: Float)
    override val negative: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.negative())
      .map(value => value: Float)
    override val neutral: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.neutral())
      .map(value => value: Float)
    override val mixed: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.mixed())
      .map(value => value: Float)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.SentimentScore
  ): zio.aws.comprehend.model.SentimentScore.ReadOnly = new Wrapper(impl)
}
