package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.ComprehendArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceResponse(
    resourceArn: Optional[ComprehendArn] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.comprehend.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ListTagsForResourceResponse
      .builder()
      .optionallyWith(
        resourceArn.map(value => ComprehendArn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.comprehend.model.ListTagsForResourceResponse.wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.ListTagsForResourceResponse =
      zio.aws.comprehend.model.ListTagsForResourceResponse(
        resourceArn.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resourceArn: Optional[ComprehendArn]
    def tags: Optional[List[zio.aws.comprehend.model.Tag.ReadOnly]]
    def getResourceArn: ZIO[Any, AwsError, ComprehendArn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.comprehend.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ListTagsForResourceResponse
  ) extends zio.aws.comprehend.model.ListTagsForResourceResponse.ReadOnly {
    override val resourceArn: Optional[ComprehendArn] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => zio.aws.comprehend.model.primitives.ComprehendArn(value))
    override val tags: Optional[List[zio.aws.comprehend.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.comprehend.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ListTagsForResourceResponse
  ): zio.aws.comprehend.model.ListTagsForResourceResponse.ReadOnly =
    new Wrapper(impl)
}
