package zio.aws.comprehend.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.comprehend.model.primitives.{
  VersionName,
  Timestamp,
  Integer,
  ComprehendArnName
}
import scala.jdk.CollectionConverters.*
final case class EntityRecognizerSummary(
    recognizerName: Optional[ComprehendArnName] = Optional.Absent,
    numberOfVersions: Optional[Integer] = Optional.Absent,
    latestVersionCreatedAt: Optional[Timestamp] = Optional.Absent,
    latestVersionName: Optional[VersionName] = Optional.Absent,
    latestVersionStatus: Optional[zio.aws.comprehend.model.ModelStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.EntityRecognizerSummary = {
    import EntityRecognizerSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.EntityRecognizerSummary
      .builder()
      .optionallyWith(
        recognizerName.map(value =>
          ComprehendArnName.unwrap(value): java.lang.String
        )
      )(_.recognizerName)
      .optionallyWith(numberOfVersions.map(value => value: java.lang.Integer))(
        _.numberOfVersions
      )
      .optionallyWith(
        latestVersionCreatedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.latestVersionCreatedAt)
      .optionallyWith(
        latestVersionName.map(value =>
          VersionName.unwrap(value): java.lang.String
        )
      )(_.latestVersionName)
      .optionallyWith(latestVersionStatus.map(value => value.unwrap))(
        _.latestVersionStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.EntityRecognizerSummary.ReadOnly =
    zio.aws.comprehend.model.EntityRecognizerSummary.wrap(buildAwsValue())
}
object EntityRecognizerSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.EntityRecognizerSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.EntityRecognizerSummary =
      zio.aws.comprehend.model.EntityRecognizerSummary(
        recognizerName.map(value => value),
        numberOfVersions.map(value => value),
        latestVersionCreatedAt.map(value => value),
        latestVersionName.map(value => value),
        latestVersionStatus.map(value => value)
      )
    def recognizerName: Optional[ComprehendArnName]
    def numberOfVersions: Optional[Integer]
    def latestVersionCreatedAt: Optional[Timestamp]
    def latestVersionName: Optional[VersionName]
    def latestVersionStatus: Optional[zio.aws.comprehend.model.ModelStatus]
    def getRecognizerName: ZIO[Any, AwsError, ComprehendArnName] =
      AwsError.unwrapOptionField("recognizerName", recognizerName)
    def getNumberOfVersions: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("numberOfVersions", numberOfVersions)
    def getLatestVersionCreatedAt: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("latestVersionCreatedAt", latestVersionCreatedAt)
    def getLatestVersionName: ZIO[Any, AwsError, VersionName] =
      AwsError.unwrapOptionField("latestVersionName", latestVersionName)
    def getLatestVersionStatus
        : ZIO[Any, AwsError, zio.aws.comprehend.model.ModelStatus] =
      AwsError.unwrapOptionField("latestVersionStatus", latestVersionStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.EntityRecognizerSummary
  ) extends zio.aws.comprehend.model.EntityRecognizerSummary.ReadOnly {
    override val recognizerName: Optional[ComprehendArnName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recognizerName())
        .map(value =>
          zio.aws.comprehend.model.primitives.ComprehendArnName(value)
        )
    override val numberOfVersions: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.numberOfVersions())
      .map(value => value: Integer)
    override val latestVersionCreatedAt: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestVersionCreatedAt())
        .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val latestVersionName: Optional[VersionName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestVersionName())
        .map(value => zio.aws.comprehend.model.primitives.VersionName(value))
    override val latestVersionStatus
        : Optional[zio.aws.comprehend.model.ModelStatus] = zio.aws.core.internal
      .optionalFromNullable(impl.latestVersionStatus())
      .map(value => zio.aws.comprehend.model.ModelStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.EntityRecognizerSummary
  ): zio.aws.comprehend.model.EntityRecognizerSummary.ReadOnly = new Wrapper(
    impl
  )
}
