package zio.aws.comprehend.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.comprehend.model.primitives.{
  DocumentClassifierArn,
  IamRoleArn,
  AnyLengthString,
  Timestamp,
  KmsKeyId,
  VersionName
}
import scala.jdk.CollectionConverters.*
final case class DocumentClassifierProperties(
    documentClassifierArn: Optional[DocumentClassifierArn] = Optional.Absent,
    languageCode: Optional[zio.aws.comprehend.model.LanguageCode] =
      Optional.Absent,
    status: Optional[zio.aws.comprehend.model.ModelStatus] = Optional.Absent,
    message: Optional[AnyLengthString] = Optional.Absent,
    submitTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    trainingStartTime: Optional[Timestamp] = Optional.Absent,
    trainingEndTime: Optional[Timestamp] = Optional.Absent,
    inputDataConfig: Optional[
      zio.aws.comprehend.model.DocumentClassifierInputDataConfig
    ] = Optional.Absent,
    outputDataConfig: Optional[
      zio.aws.comprehend.model.DocumentClassifierOutputDataConfig
    ] = Optional.Absent,
    classifierMetadata: Optional[zio.aws.comprehend.model.ClassifierMetadata] =
      Optional.Absent,
    dataAccessRoleArn: Optional[IamRoleArn] = Optional.Absent,
    volumeKmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    vpcConfig: Optional[zio.aws.comprehend.model.VpcConfig] = Optional.Absent,
    mode: Optional[zio.aws.comprehend.model.DocumentClassifierMode] =
      Optional.Absent,
    modelKmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    versionName: Optional[VersionName] = Optional.Absent,
    sourceModelArn: Optional[DocumentClassifierArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DocumentClassifierProperties = {
    import DocumentClassifierProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DocumentClassifierProperties
      .builder()
      .optionallyWith(
        documentClassifierArn.map(value =>
          DocumentClassifierArn.unwrap(value): java.lang.String
        )
      )(_.documentClassifierArn)
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        message.map(value => AnyLengthString.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        submitTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.submitTime)
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        trainingStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.trainingStartTime)
      .optionallyWith(
        trainingEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.trainingEndTime)
      .optionallyWith(inputDataConfig.map(value => value.buildAwsValue()))(
        _.inputDataConfig
      )
      .optionallyWith(outputDataConfig.map(value => value.buildAwsValue()))(
        _.outputDataConfig
      )
      .optionallyWith(classifierMetadata.map(value => value.buildAwsValue()))(
        _.classifierMetadata
      )
      .optionallyWith(
        dataAccessRoleArn.map(value =>
          IamRoleArn.unwrap(value): java.lang.String
        )
      )(_.dataAccessRoleArn)
      .optionallyWith(
        volumeKmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.volumeKmsKeyId)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .optionallyWith(
        modelKmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.modelKmsKeyId)
      .optionallyWith(
        versionName.map(value => VersionName.unwrap(value): java.lang.String)
      )(_.versionName)
      .optionallyWith(
        sourceModelArn.map(value =>
          DocumentClassifierArn.unwrap(value): java.lang.String
        )
      )(_.sourceModelArn)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DocumentClassifierProperties.ReadOnly =
    zio.aws.comprehend.model.DocumentClassifierProperties.wrap(buildAwsValue())
}
object DocumentClassifierProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DocumentClassifierProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DocumentClassifierProperties =
      zio.aws.comprehend.model.DocumentClassifierProperties(
        documentClassifierArn.map(value => value),
        languageCode.map(value => value),
        status.map(value => value),
        message.map(value => value),
        submitTime.map(value => value),
        endTime.map(value => value),
        trainingStartTime.map(value => value),
        trainingEndTime.map(value => value),
        inputDataConfig.map(value => value.asEditable),
        outputDataConfig.map(value => value.asEditable),
        classifierMetadata.map(value => value.asEditable),
        dataAccessRoleArn.map(value => value),
        volumeKmsKeyId.map(value => value),
        vpcConfig.map(value => value.asEditable),
        mode.map(value => value),
        modelKmsKeyId.map(value => value),
        versionName.map(value => value),
        sourceModelArn.map(value => value)
      )
    def documentClassifierArn: Optional[DocumentClassifierArn]
    def languageCode: Optional[zio.aws.comprehend.model.LanguageCode]
    def status: Optional[zio.aws.comprehend.model.ModelStatus]
    def message: Optional[AnyLengthString]
    def submitTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def trainingStartTime: Optional[Timestamp]
    def trainingEndTime: Optional[Timestamp]
    def inputDataConfig: Optional[
      zio.aws.comprehend.model.DocumentClassifierInputDataConfig.ReadOnly
    ]
    def outputDataConfig: Optional[
      zio.aws.comprehend.model.DocumentClassifierOutputDataConfig.ReadOnly
    ]
    def classifierMetadata
        : Optional[zio.aws.comprehend.model.ClassifierMetadata.ReadOnly]
    def dataAccessRoleArn: Optional[IamRoleArn]
    def volumeKmsKeyId: Optional[KmsKeyId]
    def vpcConfig: Optional[zio.aws.comprehend.model.VpcConfig.ReadOnly]
    def mode: Optional[zio.aws.comprehend.model.DocumentClassifierMode]
    def modelKmsKeyId: Optional[KmsKeyId]
    def versionName: Optional[VersionName]
    def sourceModelArn: Optional[DocumentClassifierArn]
    def getDocumentClassifierArn: ZIO[Any, AwsError, DocumentClassifierArn] =
      AwsError.unwrapOptionField("documentClassifierArn", documentClassifierArn)
    def getLanguageCode
        : ZIO[Any, AwsError, zio.aws.comprehend.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getStatus: ZIO[Any, AwsError, zio.aws.comprehend.model.ModelStatus] =
      AwsError.unwrapOptionField("status", status)
    def getMessage: ZIO[Any, AwsError, AnyLengthString] =
      AwsError.unwrapOptionField("message", message)
    def getSubmitTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("submitTime", submitTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getTrainingStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("trainingStartTime", trainingStartTime)
    def getTrainingEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("trainingEndTime", trainingEndTime)
    def getInputDataConfig: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.DocumentClassifierInputDataConfig.ReadOnly
    ] = AwsError.unwrapOptionField("inputDataConfig", inputDataConfig)
    def getOutputDataConfig: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.DocumentClassifierOutputDataConfig.ReadOnly
    ] = AwsError.unwrapOptionField("outputDataConfig", outputDataConfig)
    def getClassifierMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.ClassifierMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("classifierMetadata", classifierMetadata)
    def getDataAccessRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("dataAccessRoleArn", dataAccessRoleArn)
    def getVolumeKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("volumeKmsKeyId", volumeKmsKeyId)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.comprehend.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getMode
        : ZIO[Any, AwsError, zio.aws.comprehend.model.DocumentClassifierMode] =
      AwsError.unwrapOptionField("mode", mode)
    def getModelKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("modelKmsKeyId", modelKmsKeyId)
    def getVersionName: ZIO[Any, AwsError, VersionName] =
      AwsError.unwrapOptionField("versionName", versionName)
    def getSourceModelArn: ZIO[Any, AwsError, DocumentClassifierArn] =
      AwsError.unwrapOptionField("sourceModelArn", sourceModelArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DocumentClassifierProperties
  ) extends zio.aws.comprehend.model.DocumentClassifierProperties.ReadOnly {
    override val documentClassifierArn: Optional[DocumentClassifierArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentClassifierArn())
        .map(value =>
          zio.aws.comprehend.model.primitives.DocumentClassifierArn(value)
        )
    override val languageCode: Optional[zio.aws.comprehend.model.LanguageCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.languageCode())
        .map(value => zio.aws.comprehend.model.LanguageCode.wrap(value))
    override val status: Optional[zio.aws.comprehend.model.ModelStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.comprehend.model.ModelStatus.wrap(value))
    override val message: Optional[AnyLengthString] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.comprehend.model.primitives.AnyLengthString(value))
    override val submitTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.submitTime())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val trainingStartTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.trainingStartTime())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val trainingEndTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.trainingEndTime())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val inputDataConfig: Optional[
      zio.aws.comprehend.model.DocumentClassifierInputDataConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.inputDataConfig())
      .map(value =>
        zio.aws.comprehend.model.DocumentClassifierInputDataConfig.wrap(value)
      )
    override val outputDataConfig: Optional[
      zio.aws.comprehend.model.DocumentClassifierOutputDataConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.outputDataConfig())
      .map(value =>
        zio.aws.comprehend.model.DocumentClassifierOutputDataConfig.wrap(value)
      )
    override val classifierMetadata
        : Optional[zio.aws.comprehend.model.ClassifierMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.classifierMetadata())
        .map(value => zio.aws.comprehend.model.ClassifierMetadata.wrap(value))
    override val dataAccessRoleArn: Optional[IamRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.dataAccessRoleArn())
      .map(value => zio.aws.comprehend.model.primitives.IamRoleArn(value))
    override val volumeKmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeKmsKeyId())
      .map(value => zio.aws.comprehend.model.primitives.KmsKeyId(value))
    override val vpcConfig
        : Optional[zio.aws.comprehend.model.VpcConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.comprehend.model.VpcConfig.wrap(value))
    override val mode
        : Optional[zio.aws.comprehend.model.DocumentClassifierMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mode())
        .map(value =>
          zio.aws.comprehend.model.DocumentClassifierMode.wrap(value)
        )
    override val modelKmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.modelKmsKeyId())
      .map(value => zio.aws.comprehend.model.primitives.KmsKeyId(value))
    override val versionName: Optional[VersionName] = zio.aws.core.internal
      .optionalFromNullable(impl.versionName())
      .map(value => zio.aws.comprehend.model.primitives.VersionName(value))
    override val sourceModelArn: Optional[DocumentClassifierArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceModelArn())
        .map(value =>
          zio.aws.comprehend.model.primitives.DocumentClassifierArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DocumentClassifierProperties
  ): zio.aws.comprehend.model.DocumentClassifierProperties.ReadOnly =
    new Wrapper(impl)
}
