package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.JobId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StopTargetedSentimentDetectionJobResponse(
    jobId: Optional[JobId] = Optional.Absent,
    jobStatus: Optional[zio.aws.comprehend.model.JobStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.StopTargetedSentimentDetectionJobResponse = {
    import StopTargetedSentimentDetectionJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.StopTargetedSentimentDetectionJobResponse
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.StopTargetedSentimentDetectionJobResponse.ReadOnly =
    zio.aws.comprehend.model.StopTargetedSentimentDetectionJobResponse
      .wrap(buildAwsValue())
}
object StopTargetedSentimentDetectionJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.StopTargetedSentimentDetectionJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.StopTargetedSentimentDetectionJobResponse =
      zio.aws.comprehend.model.StopTargetedSentimentDetectionJobResponse(
        jobId.map(value => value),
        jobStatus.map(value => value)
      )
    def jobId: Optional[JobId]
    def jobStatus: Optional[zio.aws.comprehend.model.JobStatus]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getJobStatus: ZIO[Any, AwsError, zio.aws.comprehend.model.JobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.StopTargetedSentimentDetectionJobResponse
  ) extends zio.aws.comprehend.model.StopTargetedSentimentDetectionJobResponse.ReadOnly {
    override val jobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.comprehend.model.primitives.JobId(value))
    override val jobStatus: Optional[zio.aws.comprehend.model.JobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobStatus())
        .map(value => zio.aws.comprehend.model.JobStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.StopTargetedSentimentDetectionJobResponse
  ): zio.aws.comprehend.model.StopTargetedSentimentDetectionJobResponse.ReadOnly =
    new Wrapper(impl)
}
