package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.S3Uri
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class InputDataConfig(
    s3Uri: S3Uri,
    inputFormat: Optional[zio.aws.comprehend.model.InputFormat] =
      Optional.Absent,
    documentReaderConfig: Optional[
      zio.aws.comprehend.model.DocumentReaderConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.InputDataConfig = {
    import InputDataConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.InputDataConfig
      .builder()
      .s3Uri(S3Uri.unwrap(s3Uri): java.lang.String)
      .optionallyWith(inputFormat.map(value => value.unwrap))(_.inputFormat)
      .optionallyWith(documentReaderConfig.map(value => value.buildAwsValue()))(
        _.documentReaderConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.InputDataConfig.ReadOnly =
    zio.aws.comprehend.model.InputDataConfig.wrap(buildAwsValue())
}
object InputDataConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.InputDataConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.InputDataConfig =
      zio.aws.comprehend.model.InputDataConfig(
        s3Uri,
        inputFormat.map(value => value),
        documentReaderConfig.map(value => value.asEditable)
      )
    def s3Uri: S3Uri
    def inputFormat: Optional[zio.aws.comprehend.model.InputFormat]
    def documentReaderConfig
        : Optional[zio.aws.comprehend.model.DocumentReaderConfig.ReadOnly]
    def getS3Uri: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3Uri)
    def getInputFormat
        : ZIO[Any, AwsError, zio.aws.comprehend.model.InputFormat] =
      AwsError.unwrapOptionField("inputFormat", inputFormat)
    def getDocumentReaderConfig: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.DocumentReaderConfig.ReadOnly
    ] = AwsError.unwrapOptionField("documentReaderConfig", documentReaderConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.InputDataConfig
  ) extends zio.aws.comprehend.model.InputDataConfig.ReadOnly {
    override val s3Uri: S3Uri =
      zio.aws.comprehend.model.primitives.S3Uri(impl.s3Uri())
    override val inputFormat: Optional[zio.aws.comprehend.model.InputFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputFormat())
        .map(value => zio.aws.comprehend.model.InputFormat.wrap(value))
    override val documentReaderConfig
        : Optional[zio.aws.comprehend.model.DocumentReaderConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentReaderConfig())
        .map(value => zio.aws.comprehend.model.DocumentReaderConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.InputDataConfig
  ): zio.aws.comprehend.model.InputDataConfig.ReadOnly = new Wrapper(impl)
}
