package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EntityTypesEvaluationMetrics(
    precision: Optional[Double] = Optional.Absent,
    recall: Optional[Double] = Optional.Absent,
    f1Score: Optional[Double] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.EntityTypesEvaluationMetrics = {
    import EntityTypesEvaluationMetrics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.EntityTypesEvaluationMetrics
      .builder()
      .optionallyWith(precision.map(value => value: java.lang.Double))(
        _.precision
      )
      .optionallyWith(recall.map(value => value: java.lang.Double))(_.recall)
      .optionallyWith(f1Score.map(value => value: java.lang.Double))(_.f1Score)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.EntityTypesEvaluationMetrics.ReadOnly =
    zio.aws.comprehend.model.EntityTypesEvaluationMetrics.wrap(buildAwsValue())
}
object EntityTypesEvaluationMetrics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.EntityTypesEvaluationMetrics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.EntityTypesEvaluationMetrics =
      zio.aws.comprehend.model.EntityTypesEvaluationMetrics(
        precision.map(value => value),
        recall.map(value => value),
        f1Score.map(value => value)
      )
    def precision: Optional[Double]
    def recall: Optional[Double]
    def f1Score: Optional[Double]
    def getPrecision: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("precision", precision)
    def getRecall: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("recall", recall)
    def getF1Score: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("f1Score", f1Score)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.EntityTypesEvaluationMetrics
  ) extends zio.aws.comprehend.model.EntityTypesEvaluationMetrics.ReadOnly {
    override val precision: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.precision())
      .map(value => value: Double)
    override val recall: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.recall())
      .map(value => value: Double)
    override val f1Score: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.f1Score())
      .map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.EntityTypesEvaluationMetrics
  ): zio.aws.comprehend.model.EntityTypesEvaluationMetrics.ReadOnly =
    new Wrapper(impl)
}
