package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{
  EventTypeString,
  ClientRequestTokenString,
  JobName,
  IamRoleArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartEventsDetectionJobRequest(
    inputDataConfig: zio.aws.comprehend.model.InputDataConfig,
    outputDataConfig: zio.aws.comprehend.model.OutputDataConfig,
    dataAccessRoleArn: IamRoleArn,
    jobName: Optional[JobName] = Optional.Absent,
    languageCode: zio.aws.comprehend.model.LanguageCode,
    clientRequestToken: Optional[ClientRequestTokenString] = Optional.Absent,
    targetEventTypes: Iterable[EventTypeString],
    tags: Optional[Iterable[zio.aws.comprehend.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.StartEventsDetectionJobRequest = {
    import StartEventsDetectionJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.StartEventsDetectionJobRequest
      .builder()
      .inputDataConfig(inputDataConfig.buildAwsValue())
      .outputDataConfig(outputDataConfig.buildAwsValue())
      .dataAccessRoleArn(IamRoleArn.unwrap(dataAccessRoleArn): java.lang.String)
      .optionallyWith(
        jobName.map(value => JobName.unwrap(value): java.lang.String)
      )(_.jobName)
      .languageCode(languageCode.unwrap)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestTokenString.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .targetEventTypes(targetEventTypes.map { item =>
        EventTypeString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.StartEventsDetectionJobRequest.ReadOnly =
    zio.aws.comprehend.model.StartEventsDetectionJobRequest
      .wrap(buildAwsValue())
}
object StartEventsDetectionJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.StartEventsDetectionJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.StartEventsDetectionJobRequest =
      zio.aws.comprehend.model.StartEventsDetectionJobRequest(
        inputDataConfig.asEditable,
        outputDataConfig.asEditable,
        dataAccessRoleArn,
        jobName.map(value => value),
        languageCode,
        clientRequestToken.map(value => value),
        targetEventTypes,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def inputDataConfig: zio.aws.comprehend.model.InputDataConfig.ReadOnly
    def outputDataConfig: zio.aws.comprehend.model.OutputDataConfig.ReadOnly
    def dataAccessRoleArn: IamRoleArn
    def jobName: Optional[JobName]
    def languageCode: zio.aws.comprehend.model.LanguageCode
    def clientRequestToken: Optional[ClientRequestTokenString]
    def targetEventTypes: List[EventTypeString]
    def tags: Optional[List[zio.aws.comprehend.model.Tag.ReadOnly]]
    def getInputDataConfig
        : ZIO[Any, Nothing, zio.aws.comprehend.model.InputDataConfig.ReadOnly] =
      ZIO.succeed(inputDataConfig)
    def getOutputDataConfig: ZIO[
      Any,
      Nothing,
      zio.aws.comprehend.model.OutputDataConfig.ReadOnly
    ] = ZIO.succeed(outputDataConfig)
    def getDataAccessRoleArn: ZIO[Any, Nothing, IamRoleArn] =
      ZIO.succeed(dataAccessRoleArn)
    def getJobName: ZIO[Any, AwsError, JobName] =
      AwsError.unwrapOptionField("jobName", jobName)
    def getLanguageCode
        : ZIO[Any, Nothing, zio.aws.comprehend.model.LanguageCode] =
      ZIO.succeed(languageCode)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestTokenString] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getTargetEventTypes: ZIO[Any, Nothing, List[EventTypeString]] =
      ZIO.succeed(targetEventTypes)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.comprehend.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.StartEventsDetectionJobRequest
  ) extends zio.aws.comprehend.model.StartEventsDetectionJobRequest.ReadOnly {
    override val inputDataConfig
        : zio.aws.comprehend.model.InputDataConfig.ReadOnly =
      zio.aws.comprehend.model.InputDataConfig.wrap(impl.inputDataConfig())
    override val outputDataConfig
        : zio.aws.comprehend.model.OutputDataConfig.ReadOnly =
      zio.aws.comprehend.model.OutputDataConfig.wrap(impl.outputDataConfig())
    override val dataAccessRoleArn: IamRoleArn =
      zio.aws.comprehend.model.primitives.IamRoleArn(impl.dataAccessRoleArn())
    override val jobName: Optional[JobName] = zio.aws.core.internal
      .optionalFromNullable(impl.jobName())
      .map(value => zio.aws.comprehend.model.primitives.JobName(value))
    override val languageCode: zio.aws.comprehend.model.LanguageCode =
      zio.aws.comprehend.model.LanguageCode.wrap(impl.languageCode())
    override val clientRequestToken: Optional[ClientRequestTokenString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.comprehend.model.primitives.ClientRequestTokenString(value)
        )
    override val targetEventTypes: List[EventTypeString] = impl
      .targetEventTypes()
      .asScala
      .map { item =>
        zio.aws.comprehend.model.primitives.EventTypeString(item)
      }
      .toList
    override val tags: Optional[List[zio.aws.comprehend.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.comprehend.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.StartEventsDetectionJobRequest
  ): zio.aws.comprehend.model.StartEventsDetectionJobRequest.ReadOnly =
    new Wrapper(impl)
}
