package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.JobId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribePiiEntitiesDetectionJobRequest(jobId: JobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DescribePiiEntitiesDetectionJobRequest = {
    import DescribePiiEntitiesDetectionJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DescribePiiEntitiesDetectionJobRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DescribePiiEntitiesDetectionJobRequest.ReadOnly =
    zio.aws.comprehend.model.DescribePiiEntitiesDetectionJobRequest
      .wrap(buildAwsValue())
}
object DescribePiiEntitiesDetectionJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DescribePiiEntitiesDetectionJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.DescribePiiEntitiesDetectionJobRequest =
      zio.aws.comprehend.model.DescribePiiEntitiesDetectionJobRequest(jobId)
    def jobId: JobId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DescribePiiEntitiesDetectionJobRequest
  ) extends zio.aws.comprehend.model.DescribePiiEntitiesDetectionJobRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.comprehend.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DescribePiiEntitiesDetectionJobRequest
  ): zio.aws.comprehend.model.DescribePiiEntitiesDetectionJobRequest.ReadOnly =
    new Wrapper(impl)
}
