package zio.aws.comprehend.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.comprehend.model.primitives.{
  IamRoleArn,
  ComprehendModelArn,
  AnyLengthString,
  Timestamp,
  ComprehendEndpointArn,
  InferenceUnitsInteger
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class EndpointProperties(
    endpointArn: Option[ComprehendEndpointArn] = None,
    status: Option[zio.aws.comprehend.model.EndpointStatus] = None,
    message: Option[AnyLengthString] = None,
    modelArn: Option[ComprehendModelArn] = None,
    desiredModelArn: Option[ComprehendModelArn] = None,
    desiredInferenceUnits: Option[InferenceUnitsInteger] = None,
    currentInferenceUnits: Option[InferenceUnitsInteger] = None,
    creationTime: Option[Timestamp] = None,
    lastModifiedTime: Option[Timestamp] = None,
    dataAccessRoleArn: Option[IamRoleArn] = None,
    desiredDataAccessRoleArn: Option[IamRoleArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.EndpointProperties = {
    import EndpointProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.EndpointProperties
      .builder()
      .optionallyWith(
        endpointArn.map(value =>
          ComprehendEndpointArn.unwrap(value): java.lang.String
        )
      )(_.endpointArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        message.map(value => AnyLengthString.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        modelArn.map(value =>
          ComprehendModelArn.unwrap(value): java.lang.String
        )
      )(_.modelArn)
      .optionallyWith(
        desiredModelArn.map(value =>
          ComprehendModelArn.unwrap(value): java.lang.String
        )
      )(_.desiredModelArn)
      .optionallyWith(
        desiredInferenceUnits.map(value =>
          InferenceUnitsInteger.unwrap(value): Integer
        )
      )(_.desiredInferenceUnits)
      .optionallyWith(
        currentInferenceUnits.map(value =>
          InferenceUnitsInteger.unwrap(value): Integer
        )
      )(_.currentInferenceUnits)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        dataAccessRoleArn.map(value =>
          IamRoleArn.unwrap(value): java.lang.String
        )
      )(_.dataAccessRoleArn)
      .optionallyWith(
        desiredDataAccessRoleArn.map(value =>
          IamRoleArn.unwrap(value): java.lang.String
        )
      )(_.desiredDataAccessRoleArn)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.EndpointProperties.ReadOnly =
    zio.aws.comprehend.model.EndpointProperties.wrap(buildAwsValue())
}
object EndpointProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.EndpointProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.EndpointProperties =
      zio.aws.comprehend.model.EndpointProperties(
        endpointArn.map(value => value),
        status.map(value => value),
        message.map(value => value),
        modelArn.map(value => value),
        desiredModelArn.map(value => value),
        desiredInferenceUnits.map(value => value),
        currentInferenceUnits.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value),
        dataAccessRoleArn.map(value => value),
        desiredDataAccessRoleArn.map(value => value)
      )
    def endpointArn: Option[ComprehendEndpointArn]
    def status: Option[zio.aws.comprehend.model.EndpointStatus]
    def message: Option[AnyLengthString]
    def modelArn: Option[ComprehendModelArn]
    def desiredModelArn: Option[ComprehendModelArn]
    def desiredInferenceUnits: Option[InferenceUnitsInteger]
    def currentInferenceUnits: Option[InferenceUnitsInteger]
    def creationTime: Option[Timestamp]
    def lastModifiedTime: Option[Timestamp]
    def dataAccessRoleArn: Option[IamRoleArn]
    def desiredDataAccessRoleArn: Option[IamRoleArn]
    def getEndpointArn: ZIO[Any, AwsError, ComprehendEndpointArn] =
      AwsError.unwrapOptionField("endpointArn", endpointArn)
    def getStatus: ZIO[Any, AwsError, zio.aws.comprehend.model.EndpointStatus] =
      AwsError.unwrapOptionField("status", status)
    def getMessage: ZIO[Any, AwsError, AnyLengthString] =
      AwsError.unwrapOptionField("message", message)
    def getModelArn: ZIO[Any, AwsError, ComprehendModelArn] =
      AwsError.unwrapOptionField("modelArn", modelArn)
    def getDesiredModelArn: ZIO[Any, AwsError, ComprehendModelArn] =
      AwsError.unwrapOptionField("desiredModelArn", desiredModelArn)
    def getDesiredInferenceUnits: ZIO[Any, AwsError, InferenceUnitsInteger] =
      AwsError.unwrapOptionField("desiredInferenceUnits", desiredInferenceUnits)
    def getCurrentInferenceUnits: ZIO[Any, AwsError, InferenceUnitsInteger] =
      AwsError.unwrapOptionField("currentInferenceUnits", currentInferenceUnits)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getDataAccessRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("dataAccessRoleArn", dataAccessRoleArn)
    def getDesiredDataAccessRoleArn: ZIO[Any, AwsError, IamRoleArn] = AwsError
      .unwrapOptionField("desiredDataAccessRoleArn", desiredDataAccessRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.EndpointProperties
  ) extends zio.aws.comprehend.model.EndpointProperties.ReadOnly {
    override val endpointArn: Option[ComprehendEndpointArn] = scala
      .Option(impl.endpointArn())
      .map(value =>
        zio.aws.comprehend.model.primitives.ComprehendEndpointArn(value)
      )
    override val status: Option[zio.aws.comprehend.model.EndpointStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.comprehend.model.EndpointStatus.wrap(value))
    override val message: Option[AnyLengthString] = scala
      .Option(impl.message())
      .map(value => zio.aws.comprehend.model.primitives.AnyLengthString(value))
    override val modelArn: Option[ComprehendModelArn] = scala
      .Option(impl.modelArn())
      .map(value =>
        zio.aws.comprehend.model.primitives.ComprehendModelArn(value)
      )
    override val desiredModelArn: Option[ComprehendModelArn] = scala
      .Option(impl.desiredModelArn())
      .map(value =>
        zio.aws.comprehend.model.primitives.ComprehendModelArn(value)
      )
    override val desiredInferenceUnits: Option[InferenceUnitsInteger] = scala
      .Option(impl.desiredInferenceUnits())
      .map(value =>
        zio.aws.comprehend.model.primitives.InferenceUnitsInteger(value)
      )
    override val currentInferenceUnits: Option[InferenceUnitsInteger] = scala
      .Option(impl.currentInferenceUnits())
      .map(value =>
        zio.aws.comprehend.model.primitives.InferenceUnitsInteger(value)
      )
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val lastModifiedTime: Option[Timestamp] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val dataAccessRoleArn: Option[IamRoleArn] = scala
      .Option(impl.dataAccessRoleArn())
      .map(value => zio.aws.comprehend.model.primitives.IamRoleArn(value))
    override val desiredDataAccessRoleArn: Option[IamRoleArn] = scala
      .Option(impl.desiredDataAccessRoleArn())
      .map(value => zio.aws.comprehend.model.primitives.IamRoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.EndpointProperties
  ): zio.aws.comprehend.model.EndpointProperties.ReadOnly = new Wrapper(impl)
}
