package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.JobId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeDocumentClassificationJobRequest(jobId: JobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassificationJobRequest = {
    import DescribeDocumentClassificationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassificationJobRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DescribeDocumentClassificationJobRequest.ReadOnly =
    zio.aws.comprehend.model.DescribeDocumentClassificationJobRequest
      .wrap(buildAwsValue())
}
object DescribeDocumentClassificationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassificationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.DescribeDocumentClassificationJobRequest =
      zio.aws.comprehend.model.DescribeDocumentClassificationJobRequest(jobId)
    def jobId: JobId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassificationJobRequest
  ) extends zio.aws.comprehend.model.DescribeDocumentClassificationJobRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.comprehend.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassificationJobRequest
  ): zio.aws.comprehend.model.DescribeDocumentClassificationJobRequest.ReadOnly =
    new Wrapper(impl)
}
