package zio.aws.comprehend.model
import scala.jdk.CollectionConverters.*
sealed trait LanguageCode {
  def unwrap: software.amazon.awssdk.services.comprehend.model.LanguageCode
}
object LanguageCode {
  def wrap(
      value: software.amazon.awssdk.services.comprehend.model.LanguageCode
  ): zio.aws.comprehend.model.LanguageCode = value match {
    case software.amazon.awssdk.services.comprehend.model.LanguageCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.comprehend.model.LanguageCode.EN =>
      val r = en
      r
    case software.amazon.awssdk.services.comprehend.model.LanguageCode.ES =>
      val r = es
      r
    case software.amazon.awssdk.services.comprehend.model.LanguageCode.FR =>
      val r = fr
      r
    case software.amazon.awssdk.services.comprehend.model.LanguageCode.DE =>
      val r = de
      r
    case software.amazon.awssdk.services.comprehend.model.LanguageCode.IT =>
      val r = it
      r
    case software.amazon.awssdk.services.comprehend.model.LanguageCode.PT =>
      val r = pt
      r
    case software.amazon.awssdk.services.comprehend.model.LanguageCode.AR =>
      val r = ar
      r
    case software.amazon.awssdk.services.comprehend.model.LanguageCode.HI =>
      val r = hi
      r
    case software.amazon.awssdk.services.comprehend.model.LanguageCode.JA =>
      val r = ja
      r
    case software.amazon.awssdk.services.comprehend.model.LanguageCode.KO =>
      val r = ko
      r
    case software.amazon.awssdk.services.comprehend.model.LanguageCode.ZH =>
      val r = zh
      r
    case software.amazon.awssdk.services.comprehend.model.LanguageCode.ZH_TW =>
      val r = `zh-TW`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.comprehend.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.LanguageCode =
      software.amazon.awssdk.services.comprehend.model.LanguageCode.UNKNOWN_TO_SDK_VERSION
  }
  case object en extends zio.aws.comprehend.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.LanguageCode =
      software.amazon.awssdk.services.comprehend.model.LanguageCode.EN
  }
  case object es extends zio.aws.comprehend.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.LanguageCode =
      software.amazon.awssdk.services.comprehend.model.LanguageCode.ES
  }
  case object fr extends zio.aws.comprehend.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.LanguageCode =
      software.amazon.awssdk.services.comprehend.model.LanguageCode.FR
  }
  case object de extends zio.aws.comprehend.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.LanguageCode =
      software.amazon.awssdk.services.comprehend.model.LanguageCode.DE
  }
  case object it extends zio.aws.comprehend.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.LanguageCode =
      software.amazon.awssdk.services.comprehend.model.LanguageCode.IT
  }
  case object pt extends zio.aws.comprehend.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.LanguageCode =
      software.amazon.awssdk.services.comprehend.model.LanguageCode.PT
  }
  case object ar extends zio.aws.comprehend.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.LanguageCode =
      software.amazon.awssdk.services.comprehend.model.LanguageCode.AR
  }
  case object hi extends zio.aws.comprehend.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.LanguageCode =
      software.amazon.awssdk.services.comprehend.model.LanguageCode.HI
  }
  case object ja extends zio.aws.comprehend.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.LanguageCode =
      software.amazon.awssdk.services.comprehend.model.LanguageCode.JA
  }
  case object ko extends zio.aws.comprehend.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.LanguageCode =
      software.amazon.awssdk.services.comprehend.model.LanguageCode.KO
  }
  case object zh extends zio.aws.comprehend.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.LanguageCode =
      software.amazon.awssdk.services.comprehend.model.LanguageCode.ZH
  }
  case object `zh-TW` extends zio.aws.comprehend.model.LanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.LanguageCode =
      software.amazon.awssdk.services.comprehend.model.LanguageCode.ZH_TW
  }
}
