package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PiiEntity(
    score: Option[Float] = None,
    `type`: Option[zio.aws.comprehend.model.PiiEntityType] = None,
    beginOffset: Option[Integer] = None,
    endOffset: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.PiiEntity = {
    import PiiEntity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.PiiEntity
      .builder()
      .optionallyWith(score.map(value => value: java.lang.Float))(_.score)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(beginOffset.map(value => value: java.lang.Integer))(
        _.beginOffset
      )
      .optionallyWith(endOffset.map(value => value: java.lang.Integer))(
        _.endOffset
      )
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.PiiEntity.ReadOnly =
    zio.aws.comprehend.model.PiiEntity.wrap(buildAwsValue())
}
object PiiEntity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.PiiEntity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.PiiEntity =
      zio.aws.comprehend.model.PiiEntity(
        score.map(value => value),
        `type`.map(value => value),
        beginOffset.map(value => value),
        endOffset.map(value => value)
      )
    def score: Option[Float]
    def `type`: Option[zio.aws.comprehend.model.PiiEntityType]
    def beginOffset: Option[Integer]
    def endOffset: Option[Integer]
    def getScore: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("score", score)
    def getType: ZIO[Any, AwsError, zio.aws.comprehend.model.PiiEntityType] =
      AwsError.unwrapOptionField("type", `type`)
    def getBeginOffset: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("beginOffset", beginOffset)
    def getEndOffset: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("endOffset", endOffset)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.PiiEntity
  ) extends zio.aws.comprehend.model.PiiEntity.ReadOnly {
    override val score: Option[Float] =
      scala.Option(impl.score()).map(value => value: Float)
    override val `type`: Option[zio.aws.comprehend.model.PiiEntityType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.comprehend.model.PiiEntityType.wrap(value))
    override val beginOffset: Option[Integer] =
      scala.Option(impl.beginOffset()).map(value => value: Integer)
    override val endOffset: Option[Integer] =
      scala.Option(impl.endOffset()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.PiiEntity
  ): zio.aws.comprehend.model.PiiEntity.ReadOnly = new Wrapper(impl)
}
