package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeTargetedSentimentDetectionJobResponse(
    targetedSentimentDetectionJobProperties: Option[
      zio.aws.comprehend.model.TargetedSentimentDetectionJobProperties
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DescribeTargetedSentimentDetectionJobResponse = {
    import DescribeTargetedSentimentDetectionJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DescribeTargetedSentimentDetectionJobResponse
      .builder()
      .optionallyWith(
        targetedSentimentDetectionJobProperties.map(value =>
          value.buildAwsValue()
        )
      )(_.targetedSentimentDetectionJobProperties)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DescribeTargetedSentimentDetectionJobResponse.ReadOnly =
    zio.aws.comprehend.model.DescribeTargetedSentimentDetectionJobResponse
      .wrap(buildAwsValue())
}
object DescribeTargetedSentimentDetectionJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DescribeTargetedSentimentDetectionJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.DescribeTargetedSentimentDetectionJobResponse =
      zio.aws.comprehend.model.DescribeTargetedSentimentDetectionJobResponse(
        targetedSentimentDetectionJobProperties.map(value => value.asEditable)
      )
    def targetedSentimentDetectionJobProperties: Option[
      zio.aws.comprehend.model.TargetedSentimentDetectionJobProperties.ReadOnly
    ]
    def getTargetedSentimentDetectionJobProperties: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.TargetedSentimentDetectionJobProperties.ReadOnly
    ] = AwsError.unwrapOptionField(
      "targetedSentimentDetectionJobProperties",
      targetedSentimentDetectionJobProperties
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeTargetedSentimentDetectionJobResponse
  ) extends zio.aws.comprehend.model.DescribeTargetedSentimentDetectionJobResponse.ReadOnly {
    override val targetedSentimentDetectionJobProperties: Option[
      zio.aws.comprehend.model.TargetedSentimentDetectionJobProperties.ReadOnly
    ] = scala
      .Option(impl.targetedSentimentDetectionJobProperties())
      .map(value =>
        zio.aws.comprehend.model.TargetedSentimentDetectionJobProperties
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeTargetedSentimentDetectionJobResponse
  ): zio.aws.comprehend.model.DescribeTargetedSentimentDetectionJobResponse.ReadOnly =
    new Wrapper(impl)
}
