package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{
  VersionName,
  Timestamp,
  Integer,
  ComprehendArnName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DocumentClassifierSummary(
    documentClassifierName: Option[ComprehendArnName] = None,
    numberOfVersions: Option[Integer] = None,
    latestVersionCreatedAt: Option[Timestamp] = None,
    latestVersionName: Option[VersionName] = None,
    latestVersionStatus: Option[zio.aws.comprehend.model.ModelStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DocumentClassifierSummary = {
    import DocumentClassifierSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DocumentClassifierSummary
      .builder()
      .optionallyWith(
        documentClassifierName.map(value =>
          ComprehendArnName.unwrap(value): java.lang.String
        )
      )(_.documentClassifierName)
      .optionallyWith(numberOfVersions.map(value => value: java.lang.Integer))(
        _.numberOfVersions
      )
      .optionallyWith(
        latestVersionCreatedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.latestVersionCreatedAt)
      .optionallyWith(
        latestVersionName.map(value =>
          VersionName.unwrap(value): java.lang.String
        )
      )(_.latestVersionName)
      .optionallyWith(latestVersionStatus.map(value => value.unwrap))(
        _.latestVersionStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.DocumentClassifierSummary.ReadOnly =
    zio.aws.comprehend.model.DocumentClassifierSummary.wrap(buildAwsValue())
}
object DocumentClassifierSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DocumentClassifierSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DocumentClassifierSummary =
      zio.aws.comprehend.model.DocumentClassifierSummary(
        documentClassifierName.map(value => value),
        numberOfVersions.map(value => value),
        latestVersionCreatedAt.map(value => value),
        latestVersionName.map(value => value),
        latestVersionStatus.map(value => value)
      )
    def documentClassifierName: Option[ComprehendArnName]
    def numberOfVersions: Option[Integer]
    def latestVersionCreatedAt: Option[Timestamp]
    def latestVersionName: Option[VersionName]
    def latestVersionStatus: Option[zio.aws.comprehend.model.ModelStatus]
    def getDocumentClassifierName: ZIO[Any, AwsError, ComprehendArnName] =
      AwsError.unwrapOptionField(
        "documentClassifierName",
        documentClassifierName
      )
    def getNumberOfVersions: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("numberOfVersions", numberOfVersions)
    def getLatestVersionCreatedAt: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("latestVersionCreatedAt", latestVersionCreatedAt)
    def getLatestVersionName: ZIO[Any, AwsError, VersionName] =
      AwsError.unwrapOptionField("latestVersionName", latestVersionName)
    def getLatestVersionStatus
        : ZIO[Any, AwsError, zio.aws.comprehend.model.ModelStatus] =
      AwsError.unwrapOptionField("latestVersionStatus", latestVersionStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DocumentClassifierSummary
  ) extends zio.aws.comprehend.model.DocumentClassifierSummary.ReadOnly {
    override val documentClassifierName: Option[ComprehendArnName] = scala
      .Option(impl.documentClassifierName())
      .map(value =>
        zio.aws.comprehend.model.primitives.ComprehendArnName(value)
      )
    override val numberOfVersions: Option[Integer] =
      scala.Option(impl.numberOfVersions()).map(value => value: Integer)
    override val latestVersionCreatedAt: Option[Timestamp] = scala
      .Option(impl.latestVersionCreatedAt())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val latestVersionName: Option[VersionName] = scala
      .Option(impl.latestVersionName())
      .map(value => zio.aws.comprehend.model.primitives.VersionName(value))
    override val latestVersionStatus
        : Option[zio.aws.comprehend.model.ModelStatus] = scala
      .Option(impl.latestVersionStatus())
      .map(value => zio.aws.comprehend.model.ModelStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DocumentClassifierSummary
  ): zio.aws.comprehend.model.DocumentClassifierSummary.ReadOnly = new Wrapper(
    impl
  )
}
