package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DetectEntitiesResponse(
    entities: Option[Iterable[zio.aws.comprehend.model.Entity]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DetectEntitiesResponse = {
    import DetectEntitiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DetectEntitiesResponse
      .builder()
      .optionallyWith(
        entities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.entities)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.DetectEntitiesResponse.ReadOnly =
    zio.aws.comprehend.model.DetectEntitiesResponse.wrap(buildAwsValue())
}
object DetectEntitiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DetectEntitiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DetectEntitiesResponse =
      zio.aws.comprehend.model.DetectEntitiesResponse(
        entities.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def entities: Option[List[zio.aws.comprehend.model.Entity.ReadOnly]]
    def getEntities
        : ZIO[Any, AwsError, List[zio.aws.comprehend.model.Entity.ReadOnly]] =
      AwsError.unwrapOptionField("entities", entities)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DetectEntitiesResponse
  ) extends zio.aws.comprehend.model.DetectEntitiesResponse.ReadOnly {
    override val entities
        : Option[List[zio.aws.comprehend.model.Entity.ReadOnly]] = scala
      .Option(impl.entities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.comprehend.model.Entity.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DetectEntitiesResponse
  ): zio.aws.comprehend.model.DetectEntitiesResponse.ReadOnly = new Wrapper(
    impl
  )
}
