package zio.aws.comprehend.model
import java.lang.Integer
import zio.aws.comprehend.model.primitives.{
  IamRoleArn,
  InferenceUnitsInteger,
  ComprehendModelArn,
  ComprehendEndpointArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateEndpointRequest(
    endpointArn: ComprehendEndpointArn,
    desiredModelArn: Option[ComprehendModelArn] = None,
    desiredInferenceUnits: Option[InferenceUnitsInteger] = None,
    desiredDataAccessRoleArn: Option[IamRoleArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.UpdateEndpointRequest = {
    import UpdateEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.UpdateEndpointRequest
      .builder()
      .endpointArn(ComprehendEndpointArn.unwrap(endpointArn): java.lang.String)
      .optionallyWith(
        desiredModelArn.map(value =>
          ComprehendModelArn.unwrap(value): java.lang.String
        )
      )(_.desiredModelArn)
      .optionallyWith(
        desiredInferenceUnits.map(value =>
          InferenceUnitsInteger.unwrap(value): Integer
        )
      )(_.desiredInferenceUnits)
      .optionallyWith(
        desiredDataAccessRoleArn.map(value =>
          IamRoleArn.unwrap(value): java.lang.String
        )
      )(_.desiredDataAccessRoleArn)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.UpdateEndpointRequest.ReadOnly =
    zio.aws.comprehend.model.UpdateEndpointRequest.wrap(buildAwsValue())
}
object UpdateEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.UpdateEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.UpdateEndpointRequest =
      zio.aws.comprehend.model.UpdateEndpointRequest(
        endpointArn,
        desiredModelArn.map(value => value),
        desiredInferenceUnits.map(value => value),
        desiredDataAccessRoleArn.map(value => value)
      )
    def endpointArn: ComprehendEndpointArn
    def desiredModelArn: Option[ComprehendModelArn]
    def desiredInferenceUnits: Option[InferenceUnitsInteger]
    def desiredDataAccessRoleArn: Option[IamRoleArn]
    def getEndpointArn: ZIO[Any, Nothing, ComprehendEndpointArn] =
      ZIO.succeed(endpointArn)
    def getDesiredModelArn: ZIO[Any, AwsError, ComprehendModelArn] =
      AwsError.unwrapOptionField("desiredModelArn", desiredModelArn)
    def getDesiredInferenceUnits: ZIO[Any, AwsError, InferenceUnitsInteger] =
      AwsError.unwrapOptionField("desiredInferenceUnits", desiredInferenceUnits)
    def getDesiredDataAccessRoleArn: ZIO[Any, AwsError, IamRoleArn] = AwsError
      .unwrapOptionField("desiredDataAccessRoleArn", desiredDataAccessRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.UpdateEndpointRequest
  ) extends zio.aws.comprehend.model.UpdateEndpointRequest.ReadOnly {
    override val endpointArn: ComprehendEndpointArn =
      zio.aws.comprehend.model.primitives
        .ComprehendEndpointArn(impl.endpointArn())
    override val desiredModelArn: Option[ComprehendModelArn] = scala
      .Option(impl.desiredModelArn())
      .map(value =>
        zio.aws.comprehend.model.primitives.ComprehendModelArn(value)
      )
    override val desiredInferenceUnits: Option[InferenceUnitsInteger] = scala
      .Option(impl.desiredInferenceUnits())
      .map(value =>
        zio.aws.comprehend.model.primitives.InferenceUnitsInteger(value)
      )
    override val desiredDataAccessRoleArn: Option[IamRoleArn] = scala
      .Option(impl.desiredDataAccessRoleArn())
      .map(value => zio.aws.comprehend.model.primitives.IamRoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.UpdateEndpointRequest
  ): zio.aws.comprehend.model.UpdateEndpointRequest.ReadOnly = new Wrapper(impl)
}
