package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{
  PolicyRevisionId,
  Policy,
  ComprehendModelArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutResourcePolicyRequest(
    resourceArn: ComprehendModelArn,
    resourcePolicy: Policy,
    policyRevisionId: Option[PolicyRevisionId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.PutResourcePolicyRequest = {
    import PutResourcePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.PutResourcePolicyRequest
      .builder()
      .resourceArn(ComprehendModelArn.unwrap(resourceArn): java.lang.String)
      .resourcePolicy(Policy.unwrap(resourcePolicy): java.lang.String)
      .optionallyWith(
        policyRevisionId.map(value =>
          PolicyRevisionId.unwrap(value): java.lang.String
        )
      )(_.policyRevisionId)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.PutResourcePolicyRequest.ReadOnly =
    zio.aws.comprehend.model.PutResourcePolicyRequest.wrap(buildAwsValue())
}
object PutResourcePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.PutResourcePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.PutResourcePolicyRequest =
      zio.aws.comprehend.model.PutResourcePolicyRequest(
        resourceArn,
        resourcePolicy,
        policyRevisionId.map(value => value)
      )
    def resourceArn: ComprehendModelArn
    def resourcePolicy: Policy
    def policyRevisionId: Option[PolicyRevisionId]
    def getResourceArn: ZIO[Any, Nothing, ComprehendModelArn] =
      ZIO.succeed(resourceArn)
    def getResourcePolicy: ZIO[Any, Nothing, Policy] =
      ZIO.succeed(resourcePolicy)
    def getPolicyRevisionId: ZIO[Any, AwsError, PolicyRevisionId] =
      AwsError.unwrapOptionField("policyRevisionId", policyRevisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.PutResourcePolicyRequest
  ) extends zio.aws.comprehend.model.PutResourcePolicyRequest.ReadOnly {
    override val resourceArn: ComprehendModelArn =
      zio.aws.comprehend.model.primitives.ComprehendModelArn(impl.resourceArn())
    override val resourcePolicy: Policy =
      zio.aws.comprehend.model.primitives.Policy(impl.resourcePolicy())
    override val policyRevisionId: Option[PolicyRevisionId] = scala
      .Option(impl.policyRevisionId())
      .map(value => zio.aws.comprehend.model.primitives.PolicyRevisionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.PutResourcePolicyRequest
  ): zio.aws.comprehend.model.PutResourcePolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
