package zio.aws.comprehend.model
import java.lang.Integer
import zio.aws.comprehend.model.primitives.MaxResultsInteger
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListDocumentClassificationJobsRequest(
    filter: Option[zio.aws.comprehend.model.DocumentClassificationJobFilter] =
      None,
    nextToken: Option[String] = None,
    maxResults: Option[MaxResultsInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest = {
    import ListDocumentClassificationJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest
      .builder()
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResultsInteger.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.ListDocumentClassificationJobsRequest.ReadOnly =
    zio.aws.comprehend.model.ListDocumentClassificationJobsRequest
      .wrap(buildAwsValue())
}
object ListDocumentClassificationJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.ListDocumentClassificationJobsRequest =
      zio.aws.comprehend.model.ListDocumentClassificationJobsRequest(
        filter.map(value => value.asEditable),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def filter: Option[
      zio.aws.comprehend.model.DocumentClassificationJobFilter.ReadOnly
    ]
    def nextToken: Option[String]
    def maxResults: Option[MaxResultsInteger]
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.DocumentClassificationJobFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest
  ) extends zio.aws.comprehend.model.ListDocumentClassificationJobsRequest.ReadOnly {
    override val filter: Option[
      zio.aws.comprehend.model.DocumentClassificationJobFilter.ReadOnly
    ] = scala
      .Option(impl.filter())
      .map(value =>
        zio.aws.comprehend.model.DocumentClassificationJobFilter.wrap(value)
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[MaxResultsInteger] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.comprehend.model.primitives.MaxResultsInteger(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest
  ): zio.aws.comprehend.model.ListDocumentClassificationJobsRequest.ReadOnly =
    new Wrapper(impl)
}
