package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class EntityRecognizerInputDataConfig(
    dataFormat: Option[zio.aws.comprehend.model.EntityRecognizerDataFormat] =
      None,
    entityTypes: Iterable[zio.aws.comprehend.model.EntityTypesListItem],
    documents: Option[zio.aws.comprehend.model.EntityRecognizerDocuments] =
      None,
    annotations: Option[zio.aws.comprehend.model.EntityRecognizerAnnotations] =
      None,
    entityList: Option[zio.aws.comprehend.model.EntityRecognizerEntityList] =
      None,
    augmentedManifests: Option[
      Iterable[zio.aws.comprehend.model.AugmentedManifestsListItem]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.EntityRecognizerInputDataConfig = {
    import EntityRecognizerInputDataConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.EntityRecognizerInputDataConfig
      .builder()
      .optionallyWith(dataFormat.map(value => value.unwrap))(_.dataFormat)
      .entityTypes(entityTypes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(documents.map(value => value.buildAwsValue()))(
        _.documents
      )
      .optionallyWith(annotations.map(value => value.buildAwsValue()))(
        _.annotations
      )
      .optionallyWith(entityList.map(value => value.buildAwsValue()))(
        _.entityList
      )
      .optionallyWith(
        augmentedManifests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.augmentedManifests)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.EntityRecognizerInputDataConfig.ReadOnly =
    zio.aws.comprehend.model.EntityRecognizerInputDataConfig
      .wrap(buildAwsValue())
}
object EntityRecognizerInputDataConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.EntityRecognizerInputDataConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.EntityRecognizerInputDataConfig =
      zio.aws.comprehend.model.EntityRecognizerInputDataConfig(
        dataFormat.map(value => value),
        entityTypes.map { item =>
          item.asEditable
        },
        documents.map(value => value.asEditable),
        annotations.map(value => value.asEditable),
        entityList.map(value => value.asEditable),
        augmentedManifests.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dataFormat: Option[zio.aws.comprehend.model.EntityRecognizerDataFormat]
    def entityTypes: List[zio.aws.comprehend.model.EntityTypesListItem.ReadOnly]
    def documents
        : Option[zio.aws.comprehend.model.EntityRecognizerDocuments.ReadOnly]
    def annotations
        : Option[zio.aws.comprehend.model.EntityRecognizerAnnotations.ReadOnly]
    def entityList
        : Option[zio.aws.comprehend.model.EntityRecognizerEntityList.ReadOnly]
    def augmentedManifests: Option[
      List[zio.aws.comprehend.model.AugmentedManifestsListItem.ReadOnly]
    ]
    def getDataFormat: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.EntityRecognizerDataFormat
    ] = AwsError.unwrapOptionField("dataFormat", dataFormat)
    def getEntityTypes: ZIO[Any, Nothing, List[
      zio.aws.comprehend.model.EntityTypesListItem.ReadOnly
    ]] = ZIO.succeed(entityTypes)
    def getDocuments: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.EntityRecognizerDocuments.ReadOnly
    ] = AwsError.unwrapOptionField("documents", documents)
    def getAnnotations: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.EntityRecognizerAnnotations.ReadOnly
    ] = AwsError.unwrapOptionField("annotations", annotations)
    def getEntityList: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.EntityRecognizerEntityList.ReadOnly
    ] = AwsError.unwrapOptionField("entityList", entityList)
    def getAugmentedManifests: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.AugmentedManifestsListItem.ReadOnly
    ]] = AwsError.unwrapOptionField("augmentedManifests", augmentedManifests)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.EntityRecognizerInputDataConfig
  ) extends zio.aws.comprehend.model.EntityRecognizerInputDataConfig.ReadOnly {
    override val dataFormat
        : Option[zio.aws.comprehend.model.EntityRecognizerDataFormat] = scala
      .Option(impl.dataFormat())
      .map(value =>
        zio.aws.comprehend.model.EntityRecognizerDataFormat.wrap(value)
      )
    override val entityTypes
        : List[zio.aws.comprehend.model.EntityTypesListItem.ReadOnly] = impl
      .entityTypes()
      .asScala
      .map { item =>
        zio.aws.comprehend.model.EntityTypesListItem.wrap(item)
      }
      .toList
    override val documents
        : Option[zio.aws.comprehend.model.EntityRecognizerDocuments.ReadOnly] =
      scala
        .Option(impl.documents())
        .map(value =>
          zio.aws.comprehend.model.EntityRecognizerDocuments.wrap(value)
        )
    override val annotations: Option[
      zio.aws.comprehend.model.EntityRecognizerAnnotations.ReadOnly
    ] = scala
      .Option(impl.annotations())
      .map(value =>
        zio.aws.comprehend.model.EntityRecognizerAnnotations.wrap(value)
      )
    override val entityList
        : Option[zio.aws.comprehend.model.EntityRecognizerEntityList.ReadOnly] =
      scala
        .Option(impl.entityList())
        .map(value =>
          zio.aws.comprehend.model.EntityRecognizerEntityList.wrap(value)
        )
    override val augmentedManifests: Option[
      List[zio.aws.comprehend.model.AugmentedManifestsListItem.ReadOnly]
    ] = scala
      .Option(impl.augmentedManifests())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.comprehend.model.AugmentedManifestsListItem.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.EntityRecognizerInputDataConfig
  ): zio.aws.comprehend.model.EntityRecognizerInputDataConfig.ReadOnly =
    new Wrapper(impl)
}
