package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeDocumentClassificationJobResponse(
    documentClassificationJobProperties: Option[
      zio.aws.comprehend.model.DocumentClassificationJobProperties
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassificationJobResponse = {
    import DescribeDocumentClassificationJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassificationJobResponse
      .builder()
      .optionallyWith(
        documentClassificationJobProperties.map(value => value.buildAwsValue())
      )(_.documentClassificationJobProperties)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DescribeDocumentClassificationJobResponse.ReadOnly =
    zio.aws.comprehend.model.DescribeDocumentClassificationJobResponse
      .wrap(buildAwsValue())
}
object DescribeDocumentClassificationJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassificationJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.DescribeDocumentClassificationJobResponse =
      zio.aws.comprehend.model.DescribeDocumentClassificationJobResponse(
        documentClassificationJobProperties.map(value => value.asEditable)
      )
    def documentClassificationJobProperties: Option[
      zio.aws.comprehend.model.DocumentClassificationJobProperties.ReadOnly
    ]
    def getDocumentClassificationJobProperties: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.DocumentClassificationJobProperties.ReadOnly
    ] = AwsError.unwrapOptionField(
      "documentClassificationJobProperties",
      documentClassificationJobProperties
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassificationJobResponse
  ) extends zio.aws.comprehend.model.DescribeDocumentClassificationJobResponse.ReadOnly {
    override val documentClassificationJobProperties: Option[
      zio.aws.comprehend.model.DocumentClassificationJobProperties.ReadOnly
    ] = scala
      .Option(impl.documentClassificationJobProperties())
      .map(value =>
        zio.aws.comprehend.model.DocumentClassificationJobProperties.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassificationJobResponse
  ): zio.aws.comprehend.model.DescribeDocumentClassificationJobResponse.ReadOnly =
    new Wrapper(impl)
}
