package zio.aws.comprehend.model
import scala.jdk.CollectionConverters.*
sealed trait PiiEntitiesDetectionMode {
  def unwrap: software.amazon.awssdk.services.comprehend.model.PiiEntitiesDetectionMode
}
object PiiEntitiesDetectionMode {
  def wrap(
      value: software.amazon.awssdk.services.comprehend.model.PiiEntitiesDetectionMode
  ): zio.aws.comprehend.model.PiiEntitiesDetectionMode = value match {
    case software.amazon.awssdk.services.comprehend.model.PiiEntitiesDetectionMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntitiesDetectionMode.ONLY_REDACTION =>
      val r = ONLY_REDACTION
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntitiesDetectionMode.ONLY_OFFSETS =>
      val r = ONLY_OFFSETS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.comprehend.model.PiiEntitiesDetectionMode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntitiesDetectionMode =
      software.amazon.awssdk.services.comprehend.model.PiiEntitiesDetectionMode.UNKNOWN_TO_SDK_VERSION
  }
  case object ONLY_REDACTION
      extends zio.aws.comprehend.model.PiiEntitiesDetectionMode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntitiesDetectionMode =
      software.amazon.awssdk.services.comprehend.model.PiiEntitiesDetectionMode.ONLY_REDACTION
  }
  case object ONLY_OFFSETS
      extends zio.aws.comprehend.model.PiiEntitiesDetectionMode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntitiesDetectionMode =
      software.amazon.awssdk.services.comprehend.model.PiiEntitiesDetectionMode.ONLY_OFFSETS
  }
}
