package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeEventsDetectionJobResponse(
    eventsDetectionJobProperties: Option[
      zio.aws.comprehend.model.EventsDetectionJobProperties
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DescribeEventsDetectionJobResponse = {
    import DescribeEventsDetectionJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DescribeEventsDetectionJobResponse
      .builder()
      .optionallyWith(
        eventsDetectionJobProperties.map(value => value.buildAwsValue())
      )(_.eventsDetectionJobProperties)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DescribeEventsDetectionJobResponse.ReadOnly =
    zio.aws.comprehend.model.DescribeEventsDetectionJobResponse
      .wrap(buildAwsValue())
}
object DescribeEventsDetectionJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DescribeEventsDetectionJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.DescribeEventsDetectionJobResponse =
      zio.aws.comprehend.model.DescribeEventsDetectionJobResponse(
        eventsDetectionJobProperties.map(value => value.asEditable)
      )
    def eventsDetectionJobProperties
        : Option[zio.aws.comprehend.model.EventsDetectionJobProperties.ReadOnly]
    def getEventsDetectionJobProperties: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.EventsDetectionJobProperties.ReadOnly
    ] = AwsError.unwrapOptionField(
      "eventsDetectionJobProperties",
      eventsDetectionJobProperties
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeEventsDetectionJobResponse
  ) extends zio.aws.comprehend.model.DescribeEventsDetectionJobResponse.ReadOnly {
    override val eventsDetectionJobProperties: Option[
      zio.aws.comprehend.model.EventsDetectionJobProperties.ReadOnly
    ] = scala
      .Option(impl.eventsDetectionJobProperties())
      .map(value =>
        zio.aws.comprehend.model.EventsDetectionJobProperties.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeEventsDetectionJobResponse
  ): zio.aws.comprehend.model.DescribeEventsDetectionJobResponse.ReadOnly =
    new Wrapper(impl)
}
